/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.common.utils.CommonUtils;

public class DynamicObjectCacheMapper {
    private Map<String, Map<Object, DynamicObject>> map = new HashMap<String, Map<Object, DynamicObject>>(16);
    private Map<String, Set<String>> entityKeys = new HashMap<String, Set<String>>(16);

    public static DynamicObjectCacheMapper build(BasedataEntityType modelEntity) {
        HashMap<String, Set<String>> entityKeys = new HashMap<String, Set<String>>(16);
        Map allFields = modelEntity.getAllFields();
        for (IDataEntityProperty prop : allFields.values()) {
            if (!(prop instanceof BasedataProp)) continue;
            BasedataProp bdPro = (BasedataProp)prop;
            String entityId = bdPro.getBaseEntityId();
            HashSet<String> keySets = new HashSet<String>(16);
            MainEntityType complexType = (MainEntityType)bdPro.getDynamicComplexPropertyType();
            Collection refFields = complexType.getAllFields().values();
            for (IDataEntityProperty refField : refFields) {
                keySets.add(refField.getName());
            }
            keySets.add(complexType.getPrimaryKey().getName());
            CommonUtils.mapGetSetValue(entityKeys, entityId).addAll(keySets);
        }
        DynamicObjectCacheMapper cacheMapper = new DynamicObjectCacheMapper();
        cacheMapper.entityKeys = entityKeys;
        return cacheMapper;
    }

    public void load(String entity, Object ... objects) {
        HashSet<Object> sets = new HashSet<Object>(objects.length);
        for (Object object : objects) {
            sets.add(object);
        }
        this.loadCollection(entity, sets);
    }

    public void load(String entity, Collection<Object> objects) {
        this.loadCollection(entity, objects);
    }

    public void loadCollection(String entity, Collection<Object> objects) {
        HashSet<Object> needQueryKey = new HashSet<Object>(objects.size());
        for (Object obj : objects) {
            if (obj == null || this.map.containsKey(obj)) continue;
            needQueryKey.add(obj);
        }
        if (needQueryKey.size() != 0) {
            this.handle(entity, needQueryKey);
        }
    }

    private Map<Object, DynamicObject> handle(String entity, Collection<Object> objects) {
        String queryField = this.getQueryField(entity);
        Map dynamicObjects = null;
        dynamicObjects = StringUtils.isNotEmpty((CharSequence)queryField) ? BusinessDataServiceHelper.loadFromCache((String)entity, (String)queryField, (QFilter[])new QFilter("id", "in", objects).toArray()) : BusinessDataServiceHelper.loadFromCache((Object[])objects.toArray(new Object[objects.size()]), (String)entity);
        this.put(entity, dynamicObjects);
        return dynamicObjects;
    }

    private String getQueryField(String entity) {
        Set<String> fields = this.entityKeys.get(entity);
        if (CommonUtils.collectionIsEmpty(fields)) {
            return null;
        }
        return CommonUtils.transToStr(fields);
    }

    public void put(String entity, Map<Object, DynamicObject> dynamicObjects) {
        Map<Object, DynamicObject> objMap = this.map.get(entity);
        if (objMap == null) {
            this.map.put(entity, dynamicObjects);
        } else {
            objMap.putAll(dynamicObjects);
        }
    }

    public DynamicObject get(String entity, Object obj) {
        Map<Object, DynamicObject> handle;
        DynamicObject targetObj;
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long && ((Long)obj).compareTo(0L) == 0) {
            return null;
        }
        Map<Object, DynamicObject> objMap = this.map.get(entity);
        DynamicObject dynamicObject = targetObj = objMap != null ? objMap.get(obj) : null;
        if (targetObj == null && !(handle = this.handle(entity, Collections.singleton(obj))).isEmpty()) {
            targetObj = handle.entrySet().iterator().next().getValue();
        }
        return targetObj;
    }

    public Map<Object, DynamicObject> getAllObjsByEntityName(String entityName) {
        return this.map.get(entityName);
    }
}

