/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.mapper;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OrgAndRepresentativeMapper {
    private Map<Object, DynamicObject> orgRepresentative = new HashMap<Object, DynamicObject>();

    public void load(Collection<Object> orgids) {
        Iterator<Object> iterator = orgids.iterator();
        while (iterator.hasNext()) {
            Object org = iterator.next();
            if (!this.orgRepresentative.containsKey(org)) continue;
            iterator.remove();
        }
        if (orgids.size() != 0) {
            this.handle(orgids);
        }
    }

    public void load(Object ... ids) {
        LinkedList<Object> idList = new LinkedList<Object>();
        for (Object id : ids) {
            if (this.orgRepresentative.containsKey(id) || id == null) continue;
            idList.add(id);
        }
        if (idList.size() != 0) {
            this.handle(idList);
        }
    }

    private Map<Object, DynamicObject> handle(Collection<Object> orgids) {
        DynamicObject[] bizorgs;
        HashMap<Object, DynamicObject> orgRep = new HashMap<Object, DynamicObject>();
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,orgpattern,parent", (QFilter[])new QFilter("id", "in", orgids).toArray());
        HashMap<Object, Object> needUpSearchOrgidMap = new HashMap<Object, Object>();
        HashSet<Object> needUpSearchOrgid = new HashSet<Object>();
        for (DynamicObject org : orgs) {
            DynamicObject orgpattern = org.getDynamicObject("orgpattern");
            if (orgpattern == null) continue;
            String pattern = orgpattern.getString("patterntype");
            if ("1".equals(pattern)) {
                orgRep.put(org.getPkValue(), org);
                this.orgRepresentative.put(org.getPkValue(), org);
                continue;
            }
            needUpSearchOrgid.add(org.getPkValue());
        }
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"15").and("view.isdefault", "=", (Object)Boolean.TRUE).and("org", "in", needUpSearchOrgid);
        for (DynamicObject bizorg : bizorgs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org,parent", (QFilter[])treeTypeFilter.toArray())) {
            Object orgid = bizorg.getDynamicObject("org").getPkValue();
            DynamicObject parent = bizorg.getDynamicObject("parent");
            if (parent == null) continue;
            Object parentId = parent.getPkValue();
            if (this.orgRepresentative.containsKey(parentId)) {
                orgRep.put(orgid, parent);
                this.orgRepresentative.put(orgid, parent);
                continue;
            }
            needUpSearchOrgidMap.put(orgid, parentId);
        }
        if (needUpSearchOrgidMap.size() != 0) {
            Map<Object, DynamicObject> dealRep = this.handle(needUpSearchOrgidMap.values());
            for (Map.Entry entry : needUpSearchOrgidMap.entrySet()) {
                DynamicObject rep = dealRep.get(entry.getValue());
                orgRep.put(entry, rep);
                this.orgRepresentative.put(entry.getKey(), rep);
            }
        }
        return orgRep;
    }

    public boolean isSameRepresentative(Object org1pkvalue, Object org2pkValue) {
        DynamicObject org1 = this.orgRepresentative.get(org1pkvalue);
        DynamicObject org2 = this.orgRepresentative.get(org2pkValue);
        if (org1 == null || org2 == null) {
            return false;
        }
        return org1.getPkValue().equals(org2.getPkValue());
    }
}

