/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.mapper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;

public class OrgAndSupplierCustomerMapper {
    public static final String TYPE_CUSTOMER = "customer";
    public static final String TYPE_SUPPLIER = "supplier";
    private Map<String, DynamicObject> customAndSupllierCache = new HashMap<String, DynamicObject>();

    private String getIndexKey(String type, Object orgId) {
        StringBuilder str = new StringBuilder();
        str.append(type);
        str.append('-');
        str.append(orgId);
        return str.toString();
    }

    public void load(Set<Long> orgids) {
        this.loadInnerCustomer(orgids);
        this.loadInnerSupplier(orgids);
    }

    public void loadInnerCustomer(Set<Long> orgids) {
        if (orgids == null) {
            return;
        }
        HashSet<Long> needqueryorgids = new HashSet<Long>();
        for (Long orgId : orgids) {
            String indexKey = this.getIndexKey(TYPE_CUSTOMER, orgId);
            if (this.customAndSupllierCache.containsKey(indexKey) && !CommonUtils.idIsNotNull(orgId)) continue;
            needqueryorgids.add(orgId);
        }
        if (needqueryorgids.size() != 0) {
            this.handle(TYPE_CUSTOMER, needqueryorgids);
        }
    }

    public void loadInnerSupplier(Set<Long> orgids) {
        if (orgids == null) {
            return;
        }
        HashSet<Long> needqueryorgids = new HashSet<Long>();
        for (Long orgId : orgids) {
            String indexKey = this.getIndexKey(TYPE_SUPPLIER, orgId);
            if (this.customAndSupllierCache.containsKey(indexKey) && !CommonUtils.idIsNotNull(orgId)) continue;
            needqueryorgids.add(orgId);
        }
        if (needqueryorgids.size() != 0) {
            this.handle(TYPE_SUPPLIER, needqueryorgids);
        }
    }

    private void handle(String type, Set<Long> orgIds) {
        block5: {
            HashMap<Object, DynamicObject> orgToDynamicObject;
            block4: {
                orgToDynamicObject = new HashMap<Object, DynamicObject>();
                if (!TYPE_CUSTOMER.equals(type)) break block4;
                QFilter customerFilter = new QFilter("internal_company", "in", orgIds);
                customerFilter.and("enable", "=", (Object)Boolean.TRUE).and("status", "=", (Object)"C");
                Map customers = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (QFilter[])customerFilter.toArray());
                for (DynamicObject dynamicObject : customers.values()) {
                    DynamicObject internalCompany = dynamicObject.getDynamicObject("internal_company");
                    orgToDynamicObject.put(internalCompany.getPkValue(), dynamicObject);
                }
                for (Object object : orgIds) {
                    this.customAndSupllierCache.put(this.getIndexKey(TYPE_CUSTOMER, object), (DynamicObject)orgToDynamicObject.get(object));
                }
                break block5;
            }
            if (!TYPE_SUPPLIER.equals(type)) break block5;
            QFilter supplierFilter = new QFilter("internal_company", "in", orgIds);
            supplierFilter.and("enable", "=", (Object)Boolean.TRUE).and("status", "=", (Object)"C");
            Map suppliers = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (QFilter[])supplierFilter.toArray());
            for (DynamicObject dynamicObject : suppliers.values()) {
                DynamicObject internalCompany = dynamicObject.getDynamicObject("internal_company");
                orgToDynamicObject.put(internalCompany.getPkValue(), dynamicObject);
            }
            for (Object object : orgIds) {
                this.customAndSupllierCache.put(this.getIndexKey(TYPE_SUPPLIER, object), (DynamicObject)orgToDynamicObject.get(object));
            }
        }
    }

    public DynamicObject getInnerCustomerByOrg(DynamicObject org) {
        DynamicObject customer = null;
        if (org == null) {
            return customer;
        }
        Long pkvalue = DynamicObjectUtil.getPkValue(org);
        customer = this.getInnerCustomerByOrgId(pkvalue);
        return customer;
    }

    public DynamicObject getInnerCustomerByOrgId(Long pkvalue) {
        String indexKey = this.getIndexKey(TYPE_CUSTOMER, pkvalue);
        if (!this.customAndSupllierCache.containsKey(indexKey)) {
            HashSet<Long> orgIds = new HashSet<Long>();
            orgIds.add(pkvalue);
            this.handle(TYPE_CUSTOMER, orgIds);
        }
        DynamicObject customer = this.customAndSupllierCache.get(indexKey);
        return customer;
    }

    public DynamicObject getInnerSupplierByOrg(DynamicObject org) {
        DynamicObject supplier = null;
        if (org == null) {
            return supplier;
        }
        Long pkvalue = DynamicObjectUtil.getPkValue(org);
        supplier = this.getInnerSupplierByOrgId(pkvalue);
        return supplier;
    }

    public DynamicObject getInnerSupplierByOrgId(Long pkvalue) {
        DynamicObject supplier = null;
        if (pkvalue == null) {
            return supplier;
        }
        String indexKey = this.getIndexKey(TYPE_SUPPLIER, pkvalue);
        if (!this.customAndSupllierCache.containsKey(indexKey)) {
            HashSet<Long> orgIds = new HashSet<Long>();
            orgIds.add(pkvalue);
            this.handle(TYPE_SUPPLIER, orgIds);
        }
        supplier = this.customAndSupllierCache.get(indexKey);
        return supplier;
    }
}

