/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.currency;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.assist.MainBillAssistant;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.currency.AbstractCurrencyPricing;
import kd.scmc.ism.common.utils.PricingCheckUtils;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;

public class SrcOrderCurrencyPricing
extends AbstractCurrencyPricing {
    public SrcOrderCurrencyPricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillsModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        MainBillAssistant billAssistant = this.getServiceContext().getBillAssistant();
        for (CoupleSettleBillsModel model : models) {
            String mainbillentity = (String)model.getValue("mainbillentity");
            Long mianbillId = (Long)model.getValue("mainbillid");
            SettleBillModel mainBillObj = null;
            try {
                mainBillObj = PricingCheckUtils.getSourceOrder(billAssistant, mainbillentity, mianbillId);
            }
            catch (KDBizException e) {
                this.logFailInfo(logHandler, model.getId(), pricingkey, e.getMessage());
                continue;
            }
            DynamicObject orderCurrency = (DynamicObject)mainBillObj.getValue("settlecy");
            if (orderCurrency == null) {
                String failReason = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6765\u6e90\u8ba2\u5355\u5355\u636e\u201c\u7ed3\u7b97\u5e01\u201d\u3002", (String)"SrcOrderCurrencyIsNull", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, model.getId(), pricingkey, failReason);
                continue;
            }
            this.setCurrencyAndLog(orderCurrency, model, logHandler, pricingkey);
            ids.add(model.getId());
        }
        return ids;
    }
}

