/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.exratedate;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.exratedate.AbstractExrateDatePricing;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;

public class BillFieldExrateDatePricing
extends AbstractExrateDatePricing {
    private String fieldKey;

    public BillFieldExrateDatePricing(ISMServiceContext service, String fieldKey) {
        super(service);
        this.fieldKey = fieldKey;
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillsModel> models, ISMRequestContext context) {
        PricingLogHandler logHandler = context.getPricingLogHandler();
        HashSet<Long> ids = new HashSet<Long>(models.size());
        for (CoupleSettleBillsModel model : models) {
            long billId = model.getId();
            SettleBillModel srcBillObj = (SettleBillModel)model.getSrcBillModel();
            if (srcBillObj == null) {
                String failReason = ResManager.loadKDString((String)"\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"BizBillNotExist", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, billId, pricingkey, failReason);
                continue;
            }
            Object dateObj = srcBillObj.getValue(this.fieldKey);
            if (dateObj == null) {
                String failReason = ResManager.loadKDString((String)"\u201c\u6765\u6e90\u5355\u636e\u201d\u5bf9\u5e94\u5b57\u6bb5\u201c%s\u201d\u7684\u503c\u4e3a\u7a7a\u3002", (String)"SourceBillFieldValueIsNull", (String)"scmc-ism-form", (Object[])new Object[0]);
                logHandler.logFailInfo("exrate", billId, pricingkey, String.format(failReason, this.fieldKey));
                continue;
            }
            if (!(dateObj instanceof Date)) continue;
            Date date = (Date)dateObj;
            int n = this.getNDay(model);
            Date rateDate = this.getExRateDate(date, n);
            model.setExRateDate(rateDate);
            logHandler.logSuccessInfo("exrate", billId, pricingkey, date);
            ids.add(billId);
        }
        return ids;
    }
}

