/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.exratedate;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.exratedate.AbstractExrateDatePricing;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;

public class SysExrateDatePricing
extends AbstractExrateDatePricing {
    public SysExrateDatePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillsModel> models, ISMRequestContext context) {
        PricingLogHandler logHandler = context.getPricingLogHandler();
        Date sysDate = new Date();
        HashSet<Long> ids = new HashSet<Long>(models.size());
        for (CoupleSettleBillsModel model : models) {
            int n = this.getNDay(model);
            Date rateDate = this.getExRateDate(sysDate, n);
            model.setExRateDate(rateDate);
            ids.add(model.getId());
            logHandler.logSuccessInfo("exrate", model.getId(), pricingkey, rateDate);
        }
        return ids;
    }
}

