/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.price;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.log.SettleLogHandler;
import kd.scmc.ism.common.model.pricing.impl.price.AbstractPricePricing;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;

public abstract class AbstractPathPricePricing
extends AbstractPricePricing {
    public AbstractPathPricePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillEntriesModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(16);
        for (CoupleSettleBillEntriesModel cpEntryModel : models) {
            CoupleSettleBillEntriesModel preCpBillModel = this.getPrePriceModel(pricingkey, context, cpEntryModel);
            if (preCpBillModel == null) continue;
            context.getPathPrirce().add(preCpBillModel, cpEntryModel);
            this.setPriceAndLog(BigDecimal.ZERO, BigDecimal.ZERO, 0L, cpEntryModel, context.getPricingLogHandler(), pricingkey);
            ids.add(cpEntryModel.getId());
        }
        return ids;
    }

    protected CoupleSettleBillEntriesModel getPrePriceModel(String pricingkey, ISMRequestContext context, CoupleSettleBillEntriesModel cpEntryModel) {
        PricingLogHandler logHandler = context.getPricingLogHandler();
        SettleBillEntryModel srcEntryModel = (SettleBillEntryModel)cpEntryModel.getSrcBillModel();
        if (srcEntryModel == null) {
            this.logFailInfo(logHandler, cpEntryModel.getId(), pricingkey, PricingLang.noSrcEntry());
            return null;
        }
        long srcBillId = srcEntryModel.getBillModel().getId();
        SettleLogHandler settleLogHandler = context.getAllLogs().get(srcBillId);
        DynamicObjectCollection dataLogInfo = settleLogHandler.getDataLogInfo();
        Long preBillId = this.getPreBillId(cpEntryModel, dataLogInfo);
        if (preBillId == null) {
            this.logFailInfo(logHandler, cpEntryModel.getId(), pricingkey, this.getFailReason());
            return null;
        }
        for (CoupleSettleBillsModel cpModel : context.getSupDemBillInfos()) {
            if (!cpModel.isContain(preBillId)) continue;
            return cpModel.getEntryBySrcEntryId(srcEntryModel.getId());
        }
        this.logFailInfo(logHandler, cpEntryModel.getId(), pricingkey, PricingLang.preBillNotExist());
        return null;
    }

    protected abstract String getFailReason();

    protected abstract Long getPreBillId(CoupleSettleBillEntriesModel var1, DynamicObjectCollection var2);
}

