/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.price;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.AbstractPricing;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;

public abstract class AbstractPricePricing
extends AbstractPricing<CoupleSettleBillEntriesModel> {
    public AbstractPricePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    protected void setPriceAndLog(BigDecimal price, DynamicObject currency, CoupleSettleBillEntriesModel model, PricingLogHandler logHandler, String pricingkey) {
        this.setPriceAndLog(price, DynamicObjectUtil.getPkValue(currency), model, logHandler, pricingkey);
    }

    protected void setPriceAndLog(BigDecimal price, long currencyId, CoupleSettleBillEntriesModel model, PricingLogHandler logHandler, String pricingkey) {
        this.setPriceAndLog(price, price, currencyId, model, logHandler, pricingkey);
    }

    protected void setPriceAndLog(BigDecimal taxprice, BigDecimal price, long currencyId, CoupleSettleBillEntriesModel model, PricingLogHandler logHandler, String pricingkey) {
        this.setPriceAndLog(taxprice, price, currencyId, 0L, model, logHandler, pricingkey);
    }

    protected void setPriceAndLog(BigDecimal taxprice, BigDecimal price, long currencyId, long unitId, CoupleSettleBillEntriesModel model, PricingLogHandler logHandler, String pricingkey) {
        if (model == null) {
            return;
        }
        if (taxprice == null && price == null) {
            logHandler.logFailInfo("price", model.getId(), pricingkey, PricingLang.priceIsNull());
            return;
        }
        if (taxprice == null) {
            taxprice = price;
        }
        if (price == null) {
            price = taxprice;
        }
        model.setPriceUnit(unitId);
        model.setRePrice(price);
        model.setRePriceWithTax(taxprice);
        model.setPriceCurrencyId(currencyId);
        logHandler.logSuccessInfo("price", model.getId(), pricingkey, price);
    }

    @Override
    public String getPricingType() {
        return "price";
    }

    protected boolean validateZeroPrice(String pricingkey, PricingLogHandler logHandler, CoupleSettleBillEntriesModel model, BigDecimal taxprice, BigDecimal price) {
        boolean isPriceZero = model.getPriceRuleEntryObj().getBoolean("pricezero");
        if (!(isPriceZero || taxprice != null && taxprice.compareTo(BigDecimal.ZERO) != 0 || price != null && price.compareTo(BigDecimal.ZERO) != 0)) {
            String failReason = PricingLang.priceIsZero();
            this.logFailInfo(logHandler, model.getId(), pricingkey, failReason);
            return false;
        }
        return true;
    }
}

