/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.price;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.price.AbstractPricePricing;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;

public final class CustomPlugInPricePricing
extends AbstractPricePricing {
    public static CustomPlugInPricePricing build(ISMServiceContext serviceContext) {
        return new CustomPlugInPricePricing(serviceContext);
    }

    private CustomPlugInPricePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillEntriesModel> models, ISMRequestContext context) {
        HashMap entryModels = new HashMap(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        for (CoupleSettleBillEntriesModel entryModel : models) {
            String customplugin = entryModel.getPriceRuleEntryObj().getString("custompriceplugin");
            if (StringUtils.isEmpty((CharSequence)customplugin)) {
                this.logFailInfo(logHandler, entryModel.getId(), pricingkey, PricingLang.customPluginNotConfig());
                continue;
            }
            CommonUtils.mapGetListValue(entryModels, customplugin).add(entryModel);
        }
        if (CommonUtils.mapIsEmpty(entryModels)) {
            return new HashSet<Long>();
        }
        HashSet<Long> successIds = new HashSet<Long>(models.size());
        for (Map.Entry entry : entryModels.entrySet()) {
            String failReason;
            String className = (String)entry.getKey();
            List enties = (List)entry.getValue();
            AbstractPricePricing plugin = null;
            try {
                plugin = this.instancePlugin(className);
            }
            catch (Exception e) {
                failReason = PricingLang.customPluginInstanceFail(e);
                for (CoupleSettleBillEntriesModel pentry : enties) {
                    this.logFailInfo(logHandler, pentry.getId(), pricingkey, failReason);
                }
            }
            if (plugin == null) continue;
            try {
                log.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u53d6\u4ef7:\u6267\u884c\u63d2\u4ef6" + className);
                Set<Long> handlePricing = plugin.handlePricing(pricingkey, enties, context);
                successIds.addAll(handlePricing);
            }
            catch (Exception e) {
                failReason = PricingLang.customPluginExecuteErro(e);
                for (CoupleSettleBillEntriesModel pentry : enties) {
                    this.logFailInfo(logHandler, pentry.getId(), pricingkey, failReason);
                }
            }
        }
        return successIds;
    }

    private AbstractPricePricing instancePlugin(String className) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class pluginClass = TypesContainer.getOrRegister((String)className);
        Constructor constructor = pluginClass.getConstructor(ISMServiceContext.class);
        return (AbstractPricePricing)constructor.newInstance(this.getServiceContext());
    }
}

