/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.price;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.assist.SettleCostAsisstant;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.price.AbstractPricePricing;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;

public class SettleCostPricePricing
extends AbstractPricePricing {
    public SettleCostPricePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillEntriesModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        SettleCostAsisstant scAssistant = this.getServiceContext().getSettleCostAssistant();
        scAssistant.preLoad(models);
        for (CoupleSettleBillEntriesModel entryModel : models) {
            BigDecimal price = (BigDecimal)scAssistant.getQuoteValue(entryModel, "price");
            Long currencyId = (Long)scAssistant.getQuoteValue(entryModel, "settlecy");
            if (price == null || currencyId == null) {
                String failInfo = scAssistant.getFailInfo(entryModel);
                if (StringUtils.isEmpty((CharSequence)failInfo)) {
                    failInfo = PricingLang.priceFail();
                }
                this.logFailInfo(logHandler, entryModel.getId(), pricingkey, failInfo);
                continue;
            }
            if (!this.validateZeroPrice(pricingkey, logHandler, entryModel, price, price)) continue;
            Long unitId = scAssistant.getQuoteValue(entryModel, "unit", 0L);
            this.setPriceAndLog(price, price, currencyId, unitId, entryModel, logHandler, pricingkey);
            ids.add(entryModel.getId());
        }
        return ids;
    }
}

