/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.price;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.price.AbstractPricePricing;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;

public class SpecifyPricePricing
extends AbstractPricePricing {
    public SpecifyPricePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillEntriesModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        for (CoupleSettleBillEntriesModel model : models) {
            DynamicObject priceRuleEntryObj;
            BigDecimal price;
            if (!this.validateZeroPrice(pricingkey, logHandler, model, price = (priceRuleEntryObj = model.getPriceRuleEntryObj()).getBigDecimal("price"), price)) continue;
            this.setPriceAndLog(price, model.getBillModel().getSettleCurrencyId(), model, logHandler, pricingkey);
            ids.add(model.getId());
        }
        return ids;
    }
}

