/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.price;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.assist.MainBillAssistant;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.price.AbstractPricePricing;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.PricingCheckUtils;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;

public class SrcOrderPricePricing
extends AbstractPricePricing {
    public SrcOrderPricePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillEntriesModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        MainBillAssistant billAssistant = this.getServiceContext().getBillAssistant();
        SettleBillMapCfg mapCfg = this.getServiceContext().getMapCfg();
        for (CoupleSettleBillEntriesModel model : models) {
            String mainbillentity = (String)model.getValue("mainbillentity");
            Long mianbillId = (Long)model.getValue("mainbillid");
            Long mianEntryId = (Long)model.getValue("mainbillentryid");
            SettleBillEntryModel sourceOrderEntry = null;
            try {
                sourceOrderEntry = PricingCheckUtils.getSourceOrderEntry(billAssistant, mainbillentity, mianbillId, mianEntryId);
            }
            catch (Exception e) {
                this.logFailInfo(logHandler, model.getId(), pricingkey, e.getMessage());
                continue;
            }
            String taxPriceKey = mapCfg.getFieldKey(sourceOrderEntry.getBillEntityType(), "priceandtax");
            String priceKey = mapCfg.getFieldKey(sourceOrderEntry.getBillEntityType(), "price");
            if (StringUtils.isEmpty((CharSequence)taxPriceKey) && StringUtils.isEmpty((CharSequence)priceKey)) {
                String failReason = PricingLang.srcOrderPriceKeyNotConfig();
                this.logFailInfo(logHandler, model.getId(), pricingkey, failReason);
                continue;
            }
            DynamicObject orderCurrency = (DynamicObject)sourceOrderEntry.getValue("settlecy");
            BigDecimal taxprice = (BigDecimal)sourceOrderEntry.getValue("priceandtax");
            BigDecimal price = (BigDecimal)sourceOrderEntry.getValue("price");
            if (orderCurrency == null || price == null && taxprice == null) {
                String failReason = PricingLang.srcOrderPriceIsNull();
                this.logFailInfo(logHandler, model.getId(), pricingkey, failReason);
                continue;
            }
            if (!this.validateZeroPrice(pricingkey, logHandler, model, taxprice, price)) continue;
            DynamicObject unit = (DynamicObject)sourceOrderEntry.getValue("unit");
            this.setPriceAndLog(taxprice, price, DynamicObjectUtil.getPkValue(orderCurrency), DynamicObjectUtil.getPkValue(unit), model, logHandler, pricingkey);
            ids.add(model.getId());
        }
        return ids;
    }
}

