/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.taxrate;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.assist.OrgAssistant;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.taxrate.AbstractTaxRatePricing;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;

public class InSupplierTaxRatePricing
extends AbstractTaxRatePricing {
    public InSupplierTaxRatePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillEntriesModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        OrgAssistant orgAssistant = this.getServiceContext().getOrgAssistant();
        for (CoupleSettleBillEntriesModel model : models) {
            Long supplierOrg = model.getBillModel().getSupplierId();
            DynamicObject innerSupplier = orgAssistant.getInnerSupplier(supplierOrg);
            if (innerSupplier == null) {
                String failReason = ResManager.loadKDString((String)"\u4f9b\u5e94\u65b9\u7ed3\u7b97\u7ec4\u7ec7\u6ca1\u6709\u5185\u90e8\u4f9b\u5e94\u5546\u3002", (String)"SupplierOrgHasNotInnerSupplier", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, model.getId(), pricingkey, failReason);
                continue;
            }
            DynamicObject taxrate = innerSupplier.getDynamicObject("taxrate");
            if (taxrate == null) {
                String failReason = ResManager.loadKDString((String)"\u4f9b\u5e94\u65b9\u7ed3\u7b97\u7ec4\u7ec7\u7684\u5185\u90e8\u4f9b\u5e94\u5546\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u7a0e\u7387\u3002", (String)"SupplierOrgInnerSupplierNotSetTaxRate", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, model.getId(), pricingkey, failReason);
                continue;
            }
            this.setTaxRateAndLog(taxrate, model, logHandler, pricingkey);
            ids.add(model.getId());
        }
        return ids;
    }
}

