/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.taxrate;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.mapper.DynamicObjectCacheMapper;
import kd.scmc.ism.common.model.pricing.impl.taxrate.AbstractTaxRatePricing;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;

public class MaterialTaxRatePricing
extends AbstractTaxRatePricing {
    public MaterialTaxRatePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillEntriesModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(16);
        SettleBillMapCfg mapCfg = this.getServiceContext().getMapCfg();
        PricingLogHandler handler = context.getPricingLogHandler();
        HashMap<Long, Long> entryToMaterial = new HashMap<Long, Long>(models.size());
        for (CoupleSettleBillEntriesModel entryModel : models) {
            DynamicObject material;
            SettleBillEntryModel srcEntry = (SettleBillEntryModel)entryModel.getSrcBillModel();
            if (srcEntry == null) {
                String failReason = PricingLang.noSrcEntry();
                this.logFailInfo(handler, entryModel.getId(), pricingkey, failReason);
                continue;
            }
            String materialKey = mapCfg.getFieldKey(srcEntry.getBillEntityType(), "material");
            if (StringUtils.isEmpty((CharSequence)materialKey)) {
                String failReason = PricingLang.notConfigMaterialKey();
                this.logFailInfo(handler, entryModel.getId(), pricingkey, failReason);
            }
            if ((material = (DynamicObject)srcEntry.getValue("material")) == null) {
                String failReason = PricingLang.materialIsNull();
                this.logFailInfo(handler, entryModel.getId(), pricingkey, failReason);
                continue;
            }
            if (!"bd_material".equals(material.getDataEntityType().getName())) {
                material = material.getDynamicObject("masterid");
            }
            Long matId = material.getLong("id");
            entryToMaterial.put(entryModel.getId(), matId);
        }
        DynamicObjectCacheMapper cacheMapper = this.getServiceContext().getService(DynamicObjectCacheMapper.class);
        cacheMapper.loadCollection("bd_material", entryToMaterial.values());
        for (CoupleSettleBillEntriesModel entryModel : models) {
            Long matId = (Long)entryToMaterial.get(entryModel.getId());
            if (!CommonUtils.idIsNotNull(matId)) continue;
            DynamicObject materialObj = cacheMapper.get("bd_material", matId);
            DynamicObject taxRate = materialObj.getDynamicObject("taxrate");
            if (taxRate == null) {
                String failReason = PricingLang.materialNotConfigTaxRate(materialObj.getString("number"));
                this.logFailInfo(handler, entryModel.getId(), pricingkey, failReason);
                continue;
            }
            this.setTaxRateAndLog(taxRate, entryModel, handler, pricingkey);
            ids.add(entryModel.getId());
        }
        return ids;
    }
}

