/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.taxrate;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.assist.MainBillAssistant;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.taxrate.AbstractTaxRatePricing;
import kd.scmc.ism.common.utils.PricingCheckUtils;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;

public class SrcOrderTaxRatePricing
extends AbstractTaxRatePricing {
    public SrcOrderTaxRatePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillEntriesModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        MainBillAssistant billAssistant = this.getServiceContext().getBillAssistant();
        for (CoupleSettleBillEntriesModel model : models) {
            String mainbillentity = (String)model.getValue("mainbillentity");
            Long mianbillId = (Long)model.getValue("mainbillid");
            Long mianEntryId = (Long)model.getValue("mainbillentryid");
            SettleBillEntryModel sourceOrderEntry = null;
            try {
                sourceOrderEntry = PricingCheckUtils.getSourceOrderEntry(billAssistant, mainbillentity, mianbillId, mianEntryId);
            }
            catch (Exception e) {
                this.logFailInfo(logHandler, model.getId(), pricingkey, e.getMessage());
                continue;
            }
            DynamicObject orderTaxRate = (DynamicObject)sourceOrderEntry.getValue("taxrateid");
            if (orderTaxRate == null) {
                String failReason = ResManager.loadKDString((String)"\u6765\u6e90\u8ba2\u5355\u5355\u636e\u7a0e\u7387\u5b57\u6bb5\u503c\u4e3a\u7a7a\u3002", (String)"SrcOrderTaxrateIsNull", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, model.getId(), pricingkey, failReason);
                continue;
            }
            this.setTaxRateAndLog(orderTaxRate, model, logHandler, pricingkey);
            ids.add(model.getId());
        }
        return ids;
    }
}

