/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.settlebill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.ism.common.model.settlebill.SettleBillDeleter;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.model.core.BizLocker;
import kd.scmc.ism.model.core.impl.SettleOperFailInfoHandle;
import kd.scmc.ism.model.core.settle.ISettleOper;
import kd.scmc.ism.model.core.settle.SettleOperSplitter;
import kd.scmc.ism.model.core.settle.impl.SettleOperExecute;
import kd.scmc.ism.model.core.settle.impl.SettleOperRedo;

public class SettleBillGenerator {
    private boolean strictLock = false;
    protected static final Log logger = LogFactory.getLog(SettleBillDeleter.class);
    private List<ISettleOper> settleOpers = new ArrayList<ISettleOper>(16);

    public SettleBillGenerator() {
        this.settleOpers.add(new SettleOperExecute());
        this.settleOpers.add(new SettleOperRedo());
        this.settleOpers.add(new SettleOperFailInfoHandle());
    }

    public SettleBillGenerator(boolean strictLock) {
        this();
        this.strictLock = strictLock;
    }

    public SettleOperResult generate(String billtype, Collection<Long> billIds) {
        SettleOperResult result;
        block17: {
            result = new SettleOperResult();
            try (BizLocker locker = BizLocker.create(billIds, "SETTLE", this.strictLock);){
                Set<Long> lockedIds = locker.getLockedIds();
                logger.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u6267\u884c\u7ed3\u7b97\uff1a\u3010%s:%s\u3011", billtype, billIds));
                if (lockedIds.isEmpty()) break block17;
                SettleOperSplitter spo = SettleOperSplitter.doParse(lockedIds, billtype);
                for (ISettleOper iSettleOper : this.settleOpers) {
                    TraceSpan trace = Tracer.create((String)("SettleBillGenerator-" + iSettleOper.getClass().getName()), (String)"doSettleOper()");
                    Throwable throwable = null;
                    try {
                        result.combine(iSettleOper.doSettleOper(spo));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (trace == null) continue;
                        if (throwable != null) {
                            try {
                                trace.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        trace.close();
                    }
                }
                for (Map.Entry entry : locker.getLockFailedInfos().entrySet()) {
                    result.addFailInfo((Long)entry.getKey(), (ErrorCode)entry.getValue());
                }
            }
        }
        return result;
    }
}

