/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.settlebill;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.action.SettleActionFactory;
import kd.scmc.ism.business.action.SettleActionProcessor;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.result.SettleOperResult;

public class SettleBillValidator {
    private Set<Long> allSucessIds = new HashSet<Long>(128);
    private Set<Long> allFaildIds = new HashSet<Long>(128);
    private Set<Long> noSettleIds = new HashSet<Long>(128);

    public void validateBill(Map<String, Collection<Long>> billInfos) {
        this.allSucessIds.clear();
        this.allFaildIds.clear();
        this.noSettleIds.clear();
        HashSet<Long> billIds = new HashSet<Long>(128);
        for (Collection<Long> infoIds : billInfos.values()) {
            billIds.addAll(infoIds);
        }
        this.checkSettleLog(billIds);
        HashMap<String, Set<Long>> checkBillInfos = new HashMap<String, Set<Long>>();
        for (Map.Entry<String, Collection<Long>> infoIds : billInfos.entrySet()) {
            Collection<Long> entityIds = infoIds.getValue();
            HashSet<Long> checkIds = new HashSet<Long>(entityIds);
            checkIds.removeAll(this.allSucessIds);
            checkIds.removeAll(this.allFaildIds);
            if (checkIds.isEmpty()) continue;
            checkBillInfos.put(infoIds.getKey(), checkIds);
        }
        if (checkBillInfos.isEmpty()) {
            return;
        }
        this.checkCanSettle(checkBillInfos);
    }

    private void checkSettleLog(Collection<Long> billIds) {
        DataSet settleLogDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ism_settlelog", (String)"sourceid, createstatus", (QFilter[])new QFilter("sourceid", "in", billIds).toArray(), (String)"");
        for (Row row : settleLogDs) {
            Long billId = row.getLong("sourceid");
            String status = row.getString("createstatus");
            if ("A".equals(status) || "E".equals(status) || "N".equals(status)) {
                this.allSucessIds.add(billId);
                continue;
            }
            if ("D".equals(status) || "C".equals(status) || "U".equals(status)) continue;
            this.allFaildIds.add(billId);
        }
    }

    private void checkCanSettle(Map<String, Set<Long>> billIds) {
        ISMRequestContext req = ISMRequestContext.create();
        req.getReqBillIds().putAll(billIds);
        SettleActionProcessor processor = SettleActionProcessor.build(SettleActionFactory.buildValidateSettleActions(), ISMServiceContext.build());
        processor.doProcess(req);
        SettleOperResult operResult = req.getOperResult();
        this.noSettleIds.addAll(operResult.getFailReasons().keySet());
    }

    public Set<Long> getAllFaildIds() {
        return this.allFaildIds;
    }

    public Set<Long> getNoSettleIds() {
        return this.noSettleIds;
    }
}

