/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class InfoTreeNode<T> {
    private String key;
    private T value;
    private Map<String, InfoTreeNode<T>> subNodes = new HashMap<String, InfoTreeNode<T>>();

    public InfoTreeNode(String key, T value) {
        this.key = key;
        this.value = value;
    }

    public InfoTreeNode<T> getSubNode(String key) {
        return this.subNodes.get(key);
    }

    public Collection<InfoTreeNode<T>> getAllSubNodes() {
        return this.subNodes.values();
    }

    public void addSubNode(InfoTreeNode<T> node) {
        this.subNodes.put(node.getKey(), node);
    }

    public String getKey() {
        return this.key;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isLeaf() {
        return this.subNodes.isEmpty();
    }

    public String toString() {
        if (this.isLeaf()) {
            return "[key=" + this.key + "]";
        }
        return "[key=" + this.key + ", subNodes=" + this.subNodes + "]";
    }
}

