/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.result;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ism.common.result.AbstractResult;
import kd.scmc.ism.common.result.BatchOpExecuteResult;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.flow.statusgroup.AbstractStatusBillGroup;

public class BatchBillOpResult
extends AbstractResult {
    private String lastOperKey = null;
    private Map<Long, String> billStatusInfo = new HashMap<Long, String>(32);
    private Map<Long, String> failReasonInfo = new HashMap<Long, String>(32);

    public BatchBillOpResult() {
        this.setSuccess(true);
    }

    public BatchBillOpResult(Map<Long, String> initBillStatus) {
        this.billStatusInfo = initBillStatus;
    }

    public void updateExecuteInfo(BatchOpExecuteResult executeResult, AbstractStatusBillGroup billGroup) {
        if (executeResult == null) {
            return;
        }
        Map<Long, String> failedBillMessage = executeResult.getFailedBillMessage();
        Collection<Map<Long, DynamicObject>> allBills = billGroup.getEntityToBillMap().values();
        for (Map<Long, DynamicObject> allBill : allBills) {
            Collection<DynamicObject> spBills = allBill.values();
            for (DynamicObject spBill : spBills) {
                Long billId = DynamicObjectUtil.getPkValue(spBill);
                String failInfo = failedBillMessage.get(billId);
                if (StringUtils.isEmpty((CharSequence)failInfo)) {
                    this.billStatusInfo.put(billId, executeResult.getTargetStatus());
                    continue;
                }
                this.billStatusInfo.put(billId, executeResult.getCurrentStatus());
                this.failReasonInfo.put(billId, failInfo);
                this.setSuccess(false);
            }
        }
        String current = executeResult.getOperKey();
        if (StringUtils.isNotEmpty((CharSequence)current)) {
            this.lastOperKey = current;
        }
    }

    public String getLastOperKey() {
        return this.lastOperKey;
    }

    public Map<Long, String> getBillStatusInfo() {
        return this.billStatusInfo;
    }

    public Map<Long, String> getFailReasonInfo() {
        return this.failReasonInfo;
    }

    public Map<String, Object> getFailReasonInfoWithNo(Map<Long, String> idToBillNos) {
        Map<Long, String> failReasons = this.getFailReasonInfo();
        HashMap<String, Object> billFailInfo = new HashMap<String, Object>(failReasons.size());
        for (Map.Entry<Long, String> info : failReasons.entrySet()) {
            billFailInfo.put(idToBillNos.get(info.getKey()), info.getValue());
        }
        return billFailInfo;
    }

    public String toString() {
        return "BatchBillOpResult [billStatusInfo=" + this.billStatusInfo + ", failReasonInfo=" + this.failReasonInfo + "]";
    }
}

