/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.result;

import java.util.HashMap;
import java.util.Map;
import kd.scmc.ism.common.result.AbstractResult;
import kd.scmc.ism.common.utils.CommonUtils;

public class BatchOpExecuteResult
extends AbstractResult {
    private Map<Long, String> failedBillMessage = new HashMap<Long, String>(16);
    private String currentStatus = null;
    private String targetStatus = null;
    private String operKey = null;

    public static BatchOpExecuteResult success(String op) {
        BatchOpExecuteResult result = new BatchOpExecuteResult();
        result.setSuccess(true);
        result.setOperKey(op);
        return result;
    }

    public static BatchOpExecuteResult fail(String op, Map<Long, String> failedBillMessage) {
        BatchOpExecuteResult result = new BatchOpExecuteResult();
        result.setSuccess(false);
        result.addFailBillMessages(failedBillMessage);
        result.setOperKey(op);
        return result;
    }

    public void combine(BatchOpExecuteResult oresult) {
        if (oresult == null) {
            return;
        }
        this.setSuccess(oresult.isSuccess() && this.isSuccess());
        Map<Long, String> oReasons = oresult.getFailedBillMessage();
        this.failedBillMessage.putAll(oReasons);
    }

    public void addFailBillMessage(Long billId, String failInfo) {
        this.setSuccess(false);
        this.failedBillMessage.put(billId, failInfo);
    }

    public void addFailBillMessages(Map<Long, String> failedBillMessage) {
        if (CommonUtils.mapIsEmpty(failedBillMessage)) {
            return;
        }
        this.setSuccess(false);
        this.failedBillMessage.putAll(failedBillMessage);
    }

    public Map<Long, String> getFailedBillMessage() {
        return this.failedBillMessage;
    }

    public void setOperaInfo(String currentStatus, String targetStatus) {
        this.targetStatus = targetStatus;
        this.currentStatus = currentStatus;
    }

    private void setOperKey(String operKey) {
        this.operKey = operKey;
    }

    public String getCurrentStatus() {
        return this.currentStatus;
    }

    public String getTargetStatus() {
        return this.targetStatus;
    }

    public String getOperKey() {
        return this.operKey;
    }

    public String toString() {
        return "[failedBillMessage=" + this.failedBillMessage + "]";
    }
}

