/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.utils;

import kd.bos.exception.KDBizException;
import kd.scmc.ism.common.model.assist.MainBillAssistant;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;

public class PricingCheckUtils {
    public static SettleBillEntryModel getSourceOrderEntry(MainBillAssistant billAssist, String mainbillentity, Long mianbillId, Long mianEntryId) throws KDBizException {
        if (CommonUtils.idIsNull(mianEntryId)) {
            throw new KDBizException(PricingLang.noSrcOrderEntry());
        }
        SettleBillModel mainBillObj = PricingCheckUtils.getSourceOrder(billAssist, mainbillentity, mianbillId);
        SettleBillEntryModel mainEntryModel = mainBillObj.getEntryModel(mianEntryId);
        if (mainEntryModel == null) {
            throw new KDBizException(PricingLang.srcOrderEntryIsNotExist());
        }
        return mainEntryModel;
    }

    public static SettleBillModel getSourceOrder(MainBillAssistant billAssist, String mainbillentity, Long mianbillId) throws KDBizException {
        if (CommonUtils.idIsNull(mianbillId)) {
            throw new KDBizException(PricingLang.noSrcOrder());
        }
        if (!billAssist.getBillCfg().getBillEntitys().contains(mainbillentity)) {
            throw new KDBizException(PricingLang.srcOrderNoConfigSettleMap(mainbillentity));
        }
        SettleBillModel mainBillObj = billAssist.getMainBillObj(mainbillentity, mianbillId);
        if (mainBillObj == null) {
            throw new KDBizException(PricingLang.srcOrderIsNotExist());
        }
        return mainBillObj;
    }
}

