/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.config;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.scmc.ism.business.helper.filter.CommonF7SelectFilterHelper;
import kd.scmc.ism.common.utils.control.FilterGridUtils;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.formplugin.template.AbstractISMBaseFormPlugin;

public class BizDirectionJudgementEdit
extends AbstractISMBaseFormPlugin
implements BeforeF7SelectListener {
    private static final String FILTERGRIDAP = "filtergridap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, "bill");
    }

    public void afterBindData(EventObject e) {
        this.setFilterGridFromText();
        this.presetdata("sysinit", "presetdatatipflex", "flexpanelap", "bar_save");
    }

    private void setFilterGridFromText() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        DynamicObject currentEntity = this.getModel().getDataEntity().getDynamicObject("bill");
        if (currentEntity != null) {
            String entityNumber = currentEntity.getString("number");
            FilterGridUtils.setFilterControlType(filterGrid, entityNumber);
            String billfilterstr = (String)this.getModel().getDataEntity().get("billfilterstr_tag");
            if (StringUtils.isNotBlank((CharSequence)billfilterstr)) {
                FilterGridUtils.setFilterControlValue(filterGrid, billfilterstr);
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{FILTERGRIDAP});
        } else {
            FilterGridUtils.setFilterControlValue(filterGrid, null);
            this.getView().setEnable(Boolean.FALSE, new String[]{FILTERGRIDAP});
        }
        this.getView().updateView(FILTERGRIDAP);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "bill": {
                this.changeBill(e);
            }
        }
    }

    private void changeBill(PropertyChangedArgs e) {
        DynamicObject bill = (DynamicObject)this.getModel().getValue("bill");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        filterGrid.SetValue(new FilterCondition());
        if (bill != null) {
            String entityNumber = bill.getString("number");
            FilterGridUtils.setFilterControlType(filterGrid, entityNumber);
            this.getView().setEnable(Boolean.TRUE, new String[]{FILTERGRIDAP});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{FILTERGRIDAP});
        }
        this.getView().updateView(FILTERGRIDAP);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(key)) {
            this.beforeSave();
        }
    }

    private void beforeSave() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        String filterString = FilterGridUtils.getFilterTextByControl(filterGrid);
        this.getModel().setValue("billfilterstr_tag", (Object)filterString);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "bill": {
                this.beforeSelectBill(e);
                break;
            }
        }
    }

    private void beforeSelectBill(BeforeF7SelectEvent e) {
        FormUtils.setF7Filter(e, CommonF7SelectFilterHelper.getSettleJudgeBillTypeFilter());
    }
}

