/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.config;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.business.helper.filter.CommonFilterHelper;
import kd.scmc.ism.common.selectstrategy.BaseDataTypeStrategy;
import kd.scmc.ism.common.selectstrategy.IColsSelectStrategy;
import kd.scmc.ism.common.selectstrategy.PriceRuleStrategy;
import kd.scmc.ism.common.selectstrategy.TypeSelectStategy;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.formplugin.template.AbstractColSelectEdit;
import kd.scmc.ism.lang.FormLang;

public class PriceRuleConfigEdit
extends AbstractColSelectEdit
implements BeforeF7SelectListener {
    private static final String SELECT_SOURCE_BILLFIELD_CB = "selectSourceBillFieldCB";
    private static final String SELECT_TARGET_BILLFIELD_CB = "selectTargetBillFieldCB";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"sourcefieldname", "targetfieldname"});
        this.addF7Listener(this, "grouprelation");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "targetbill": {
                this.clearAllTargetFields();
                break;
            }
            case "srcbillobj": {
                this.getModel().deleteEntryData("entryentity");
                break;
            }
            case "definetype": {
                this.defineTypeChange(e);
            }
        }
    }

    private void defineTypeChange(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        IDataModel model = this.getModel();
        for (ChangeData changeData : changeSet = e.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            model.setValue("grouprelation", null, rowIndex);
            model.setValue("targetfieldname", null, rowIndex);
            model.setValue("targetfieldkey", null, rowIndex);
            String defineType = (String)changeData.getNewValue();
            this.getView().setEnable(Boolean.valueOf("1".equals(defineType)), rowIndex, new String[]{"grouprelation"});
        }
    }

    private void clearAllTargetFields() {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        IDataModel model = this.getModel();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            model.setValue("targetfieldname", null, rowIndex);
            model.setValue("targetfieldkey", null, rowIndex);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = FormUtils.getControlEventKey(evt)) {
            case "sourcefieldname": {
                this.clickSourceFieldName();
                break;
            }
            case "targetfieldname": {
                this.clickTargetBillName();
                break;
            }
        }
    }

    private void clickSourceFieldName() {
        DynamicObject sourceBill = (DynamicObject)this.getValue("srcbillobj");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        PageShowHelper.showSelectColsPage(this.getView(), sourceBill.getString("number"), this.getSourceFieldStrategy(rowIndex), null, new CloseCallBack((IFormPlugin)this, SELECT_SOURCE_BILLFIELD_CB));
    }

    protected IColsSelectStrategy getSourceFieldStrategy(int rowIndex) {
        return PriceRuleStrategy.build();
    }

    private void clickTargetBillName() {
        DynamicObject targetBill = (DynamicObject)this.getValue("targetbill");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        String defineType = (String)this.getValue("definetype");
        IColsSelectStrategy targetFieldStrategy = null;
        if ("0".equals(defineType)) {
            targetFieldStrategy = this.getDirectTargetFieldStrategy(rowIndex);
        } else if ("1".equals(defineType)) {
            targetFieldStrategy = this.getGroupTargetFieldStrategy(rowIndex);
        } else {
            return;
        }
        PageShowHelper.showSelectColsPage(this.getView(), targetBill.getString("number"), targetFieldStrategy, null, new CloseCallBack((IFormPlugin)this, SELECT_TARGET_BILLFIELD_CB));
    }

    private IColsSelectStrategy getGroupTargetFieldStrategy(int rowIndex) {
        DynamicObject groupRelation = (DynamicObject)this.getValue("grouprelation", rowIndex);
        String number = groupRelation.getDynamicObject("dataobj").getString("number");
        return new BaseDataTypeStrategy(number);
    }

    protected IColsSelectStrategy getDirectTargetFieldStrategy(int rowIndex) {
        IDataEntityProperty prop = this.getSourceFieldProp(rowIndex);
        return new TypeSelectStategy(prop);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        if (SELECT_TARGET_BILLFIELD_CB.equals(sourceFldKey)) {
            this.setBillField(closedCallBackEvent, "targetfieldkey", "targetfieldname");
        } else if (SELECT_SOURCE_BILLFIELD_CB.equals(sourceFldKey)) {
            this.setBillField(closedCallBackEvent, "sourcefieldkey", "sourcefieldname");
        }
        this.getView().updateView();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "grouprelation": {
                this.groupRelationSelect(e);
                break;
            }
        }
    }

    private void groupRelationSelect(BeforeF7SelectEvent e) {
        IDataEntityProperty srcProp = this.getSourceFieldProp(e.getRow());
        if (srcProp instanceof BasedataProp) {
            e.addCustomQFilter(new QFilter("groupobj", "=", (Object)((BasedataProp)srcProp).getBaseEntityId()));
        } else {
            e.addCustomQFilter(CommonFilterHelper.getEmptyFilter());
        }
    }

    private IDataEntityProperty getSourceFieldProp(int rowIndex) {
        Object priceRuleKey = this.getModel().getValue("sourcefieldkey", rowIndex);
        if (StringUtils.isEmpty((Object)priceRuleKey)) {
            throw new KDBizException(FormLang.plsSelectPriceRuleField());
        }
        String fieldKey = DynamicObjectUtil.getLastKey(priceRuleKey.toString());
        DynamicObject sourceBill = (DynamicObject)this.getValue("srcbillobj");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)sourceBill.getString("number"));
        IDataEntityProperty prop = entityType.findProperty(fieldKey);
        return prop;
    }
}

