/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.config;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.business.helper.BizFlowShowHelper;
import kd.scmc.ism.business.helper.BotpPushHepler;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.business.helper.filter.CommonFilterHelper;
import kd.scmc.ism.business.selectlistener.billmainentity.BillEnableBFM;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.formplugin.template.AbstractISMBaseFormPlugin;
import kd.scmc.ism.lang.FormLang;

public class SettleGeneratePlanEdit
extends AbstractISMBaseFormPlugin
implements BeforeF7SelectListener {
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "sourcebilltype": {
                this.changeSourceBillType(e);
                break;
            }
            case "targetbilltype": {
                this.changeTargetBillType(e);
                break;
            }
            case "botpid": {
                this.changeBotpId(e);
                break;
            }
            case "billgenerator": {
                this.changeBillgeneratorId(e);
                break;
            }
            case "condition": {
                this.changeCondition(e);
                break;
            }
        }
    }

    private void changeCondition(PropertyChangedArgs e) {
        if (StringUtils.isEmpty((CharSequence)String.valueOf(e.getChangeSet()[0].getNewValue()))) {
            int index = e.getChangeSet()[0].getRowIndex();
            IDataModel model = this.getModel();
            model.beginInit();
            model.setValue("condtionstr", null, index);
            model.setValue("condtionstr_tag", null, index);
            model.endInit();
        }
    }

    private void changeBotpId(PropertyChangedArgs e) {
        int index = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("billgenerator", null, index);
        model.endInit();
        this.getView().updateView();
    }

    private void changeBillgeneratorId(PropertyChangedArgs e) {
        int index = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("botpid", null, index);
        model.endInit();
        this.getView().updateView();
    }

    private void changeSourceBillType(PropertyChangedArgs e) {
        int index = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("condition", null, index);
        model.setValue("condtionstr", null, index);
        model.setValue("condtionstr_tag", null, index);
        model.setValue("bizflow", null, index);
        model.setValue("targetbilltype", null, index);
        model.setValue("botpid", null, index);
        model.setValue("billgenerator", null, index);
        model.setValue("billfieldresetrule", null, index);
        model.setValue("bizflow", null, index);
        model.endInit();
        this.getView().updateView();
    }

    private void changeTargetBillType(PropertyChangedArgs e) {
        int index = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("botpid", null, index);
        model.setValue("billgenerator", null, index);
        model.setValue("billfieldresetrule", null, index);
        model.setValue("bizflow", null, index);
        model.endInit();
        this.getView().updateView();
    }

    public void registerListener(EventObject e) {
        this.addF7Listener(BillEnableBFM.getInstance(), "targetbilltype");
        FormUtils.addF7Listener((BeforeF7SelectListener)this, "botpid", "sourcebilltype", "billgenerator", "billfieldresetrule", "bizflow");
        BizFlowShowHelper.showBizFlowDesigner(this.getView(), "bizflow");
        this.addClickListeners(new String[]{"condition"});
        BotpPushHepler.showConvertRuleEdit(this.getView(), "botpid");
    }

    @Override
    protected QFilter buildF7SelectFilter(String key, BeforeF7SelectEvent e) {
        switch (key) {
            case "sourcebilltype": {
                return this.beforeSourceBillType(e);
            }
            case "botpid": {
                return this.beforeSelectBotpId(e);
            }
            case "billgenerator": {
                return this.beforeSelectBillgeneratorId(e);
            }
            case "billfieldresetrule": {
                return this.beforeSelectBillFieldRestRule(e);
            }
            case "bizflow": {
                return this.beforeSelectBizFlow(e);
            }
        }
        return null;
    }

    private QFilter beforeSelectBizFlow(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        DynamicObject targetBillType = (DynamicObject)this.getValue("targetbilltype", rowIndex);
        return new QFilter("type", "=", (Object)"BizFlow").and("entrabill", "=", (Object)targetBillType.getString("number")).and("publish", "=", (Object)Boolean.TRUE).and("discard", "=", (Object)Boolean.FALSE);
    }

    private QFilter beforeSelectBillFieldRestRule(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        DynamicObject targetBillType = (DynamicObject)this.getModel().getValue("targetbilltype", rowIndex);
        if (targetBillType != null) {
            return new QFilter("targetbill", "=", targetBillType.get("id"));
        }
        return CommonFilterHelper.getEmptyFilter();
    }

    protected QFilter beforeSourceBillType(BeforeF7SelectEvent e) {
        Map judgements = BusinessDataServiceHelper.loadFromCache((String)"ism_interorgsettlecfg", (QFilter[])CommonFilterHelper.getAllFilters());
        HashSet<Object> billIds = new HashSet<Object>(judgements.size());
        for (DynamicObject judgement : judgements.values()) {
            DynamicObject bill = judgement.getDynamicObject("bill");
            billIds.add(bill.getPkValue());
        }
        e.getFormShowParameter().setCaption(FormLang.sourceBillObjCaption());
        return new QFilter("id", "in", billIds);
    }

    protected QFilter beforeSelectBotpId(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        DynamicObject sourceBillType = (DynamicObject)this.getValue("sourcebilltype", rowIndex);
        DynamicObject targetBillType = (DynamicObject)this.getValue("targetbilltype", rowIndex);
        return new QFilter("sourceentitynumber", "=", sourceBillType.getPkValue()).and("targetentitynumber", "=", targetBillType.getPkValue());
    }

    private QFilter beforeSelectBillgeneratorId(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        this.getValue("sourcebilltype", rowIndex);
        this.getValue("targetbilltype", rowIndex);
        return null;
    }

    public void click(EventObject evt) {
        String controlEventKey = FormUtils.getControlEventKey(evt);
        if ("condition".equals(controlEventKey)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("botpconfig");
            Object conditionJson = this.getValue("condtionstr_tag", rowIndex);
            DynamicObject value = (DynamicObject)this.getValue("sourcebilltype", rowIndex);
            FormShowParameter param = PageShowHelper.getConditionParam(new CloseCallBack((IFormPlugin)this, "condition"));
            param.setAppId("057C+RJ/1S7U");
            param.getCustomParams().put("formula", conditionJson);
            param.getCustomParams().put("entitynumber", value.getString("number"));
            param.getCustomParams().put("onlyheadfield", String.valueOf(true));
            this.getView().showForm(param);
        }
        super.click(evt);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("condition".equals(e.getActionId())) {
            String returnData = (String)e.getReturnData();
            if (returnData == null) {
                return;
            }
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
            int rowIndex = this.getModel().getEntryCurrentRowIndex("botpconfig");
            IDataModel model = this.getModel();
            String exprTran = condition.getExprTran();
            model.setValue("condition", (Object)CommonUtils.cutStr(exprTran, 250), rowIndex);
            if (StringUtils.isNotEmpty((CharSequence)exprTran)) {
                model.setValue("condtionstr", (Object)condition.getDescription().getLocaleValue(), rowIndex);
                model.setValue("condtionstr_tag", (Object)returnData, rowIndex);
            } else {
                model.setValue("condtionstr", null, rowIndex);
                model.setValue("condtionstr_tag", null, rowIndex);
            }
        }
        super.closedCallBack(e);
    }
}

