/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.dynpage;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.EntityOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.scmc.ism.business.helper.BillFieldMappingDataHelper;
import kd.scmc.ism.business.helper.BillModelDataSetHelper;
import kd.scmc.ism.business.helper.BizConfigHelper;
import kd.scmc.ism.business.helper.BotpLinkHelper;
import kd.scmc.ism.business.helper.ControlResultHelper;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.business.utils.CalendarUtils;
import kd.scmc.ism.common.model.entity.ModelFilter;
import kd.scmc.ism.common.model.handler.BillFieldMapCfg;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.control.DataRangeUtils;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.common.utils.control.MulComboUtils;
import kd.scmc.ism.formplugin.template.AbstractISMDynBillFormPlugin;
import kd.scmc.ism.lang.FormLang;
import org.apache.commons.lang.ArrayUtils;

public class InterOrgSettleFormPlugin
extends AbstractISMDynBillFormPlugin
implements BeforeF7SelectListener {
    private String[] queryfields = new String[]{"number", "biztype", "biztime", "bookdate", "status", "material", "unit", "qty", "price", "priceandtax", "amount", "amountandtax", "taxrateid", "discountamount", "taxamount"};
    private String[] settleLogheadfields = new String[]{"sourceid", "sourcenum", "sourcetype", "createdate"};
    private String[] settleLogEntryfields = new String[]{"settlebilltype", "oppositeorg", "supsettleorg", "settlebillid"};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, "balanceorg_q", "oppositeorg_q");
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        MulComboEdit billType = (MulComboEdit)this.getView().getControl("billtypebiz");
        MulComboUtils.fillsWithBill(BizConfigHelper.getEnableBFMBillObjs(), billType);
        DataRangeUtils.setOneMonth(this.getModel(), "daterange_startdate", "daterange_enddate");
        DataRangeUtils.setOneMonth(this.getModel(), "settledaterange_startdate", "settledaterange_enddate");
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String opKey;
        super.afterDoOperation(event);
        switch (opKey = event.getOperateKey()) {
            case "queryarap": {
                this.queryArAp(event);
                break;
            }
            case "querysettlebill": {
                this.querySettleBill(event);
                break;
            }
            case "dorefresh": {
                this.doQuery(event);
                break;
            }
        }
    }

    private void querySettleBill(AfterDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length != 1) {
            this.getView().showTipNotification(FormLang.plsSelectOneBillCheck());
            return;
        }
        int rowIndex = rows[0];
        Long billId = (Long)this.getModel().getValue("sourceid", rowIndex);
        DynamicObject billType = (DynamicObject)this.getModel().getValue("sourcetype", rowIndex);
        String number = billType.getString("number");
        QFilter logFilter = new QFilter("sourceid", "=", (Object)billId);
        String settleBillIdField = "entryentity.settlebillid";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ism_settlelog", (String)settleBillIdField, (QFilter[])logFilter.toArray());
        HashSet<Long> settleBillIds = new HashSet<Long>(query.size());
        for (DynamicObject settleBillLog : query) {
            long settleBillId = settleBillLog.getLong(settleBillIdField);
            settleBillIds.add(settleBillId);
        }
        List<BFRowLinkDownNode> nodes = BFTrackerServiceHelper.loadLinkDownNodes((String)number, (String)"", (Long[])new Long[]{billId});
        nodes = BotpLinkHelper.getSpecBillIds(settleBillIds, nodes);
        EntityOperate source = (EntityOperate)e.getSource();
        PageShowHelper.showLookDownPage(this.getView(), source.getOperateName().getLocaleValue(), nodes);
    }

    private void queryArAp(AfterDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length != 1) {
            this.getView().showTipNotification(FormLang.plsSelectOneBillCheck());
            return;
        }
        int rowIndex = rows[0];
        Long billId = (Long)this.getModel().getValue("settlebillid", rowIndex);
        DynamicObject billType = (DynamicObject)this.getModel().getValue("settlebilltype", rowIndex);
        String number = billType.getString("number");
        List<BFRowLinkDownNode> nodes = BFTrackerServiceHelper.loadLinkDownNodes((String)number, (String)"", (Long[])new Long[]{billId});
        Set<Long> tableIds = BotpLinkHelper.getArApTableDefines();
        if ((nodes = BotpLinkHelper.getSpecBillType(nodes, tableIds)).isEmpty()) {
            this.getView().showTipNotification(FormLang.notGenerateARorAP());
            return;
        }
        EntityOperate source = (EntityOperate)e.getSource();
        PageShowHelper.showLookDownPage(this.getView(), source.getOperateName().getLocaleValue(), nodes);
    }

    @Override
    protected void doQuery(AfterDoOperationEventArgs event) {
        String[] loggerFields = (String[])ArrayUtils.addAll((Object[])this.settleLogheadfields, (Object[])this.settleLogEntryfields);
        IDataModel model = this.getModel();
        int pageIndex = this.getCurrentPageIndex();
        Set<Long> balanceorg = ControlResultHelper.getMultiBaseIds((DynamicObjectCollection)model.getValue("balanceorg_q"));
        Set<Long> oppositeorg = ControlResultHelper.getMultiBaseIds((DynamicObjectCollection)model.getValue("oppositeorg_q"));
        if (CommonUtils.collectionIsEmpty(balanceorg) && CommonUtils.collectionIsEmpty(oppositeorg)) {
            this.getView().showTipNotification(FormLang.noInputOrgInfo());
            return;
        }
        ArrayList<QFilter> settleLogFilter = new ArrayList<QFilter>();
        if (CommonUtils.collectionIsNotEmpty(balanceorg)) {
            settleLogFilter.add(new QFilter("entryentity.supsettleorg", "in", balanceorg));
        }
        if (CommonUtils.collectionIsNotEmpty(oppositeorg)) {
            settleLogFilter.add(new QFilter("entryentity.oppositeorg", "in", oppositeorg));
        }
        Date startDate = (Date)model.getValue("settledaterange_startdate");
        Date endDate = (Date)model.getValue("settledaterange_enddate");
        settleLogFilter.add(this.getSettleDateFilter(startDate, endDate));
        HashSet<String> billTypeNums = ControlResultHelper.getMultiSelectSet((String)this.getModel().getValue("billtypebiz"));
        if (CommonUtils.collectionIsEmpty(billTypeNums)) {
            billTypeNums = CommonUtils.isNull(billTypeNums) ? new HashSet<String>(16) : billTypeNums;
            billTypeNums.addAll(BizConfigHelper.getEnableBFMBills());
        }
        settleLogFilter.add(new QFilter("sourcetype", "in", billTypeNums));
        String selectedFields = BillFieldMappingDataHelper.buildSelectedFieldsSrt(this.settleLogheadfields, "entryentity", this.settleLogEntryfields);
        String algoKey = ((Object)((Object)this)).getClass() + "getFilterDataSet";
        Algo algo = Algo.create((String)algoKey);
        OrmInput logsIO = new OrmInput(algoKey, "ism_settlelog", selectedFields, settleLogFilter.toArray(new QFilter[settleLogFilter.size()]));
        DataSet logsData = algo.createDataSet(new Input[]{logsIO});
        BillFieldMapCfg fieldMapCfg = new BillFieldMapCfg(billTypeNums);
        DataSet billsData = BillModelDataSetHelper.parallelGetDataWithModelFilter(this.createBillIds(billTypeNums, logsData), fieldMapCfg, this.queryfields, this.createModelFilter());
        model.deleteEntryData("entryentity");
        if (billsData == null || billsData.isEmpty()) {
            this.getView().showTipNotification(FormLang.noQueryData());
            return;
        }
        JoinDataSet joinDataSet = logsData.join(billsData).on("settlebillid", "billid").select(loggerFields, this.queryfields);
        DataSet result = joinDataSet.finish().orderBy(new String[]{"biztime desc"});
        TableValueSetter vs = new TableValueSetter(new String[0]);
        while (result.hasNext()) {
            Row row = result.next();
            this.loadRowEntry(vs, row, this.queryfields);
            this.loadRowEntry(vs, row, loggerFields);
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.setCurrentPageIndex(event.getOperateKey(), pageIndex);
        this.getView().updateView("entryentity");
    }

    private List<ModelFilter> createModelFilter() {
        ArrayList<ModelFilter> filters = new ArrayList<ModelFilter>(16);
        Date startdate = (Date)this.getModel().getValue("daterange_startdate");
        Date enddate = (Date)this.getModel().getValue("daterange_enddate");
        if (startdate != null) {
            filters.add(new ModelFilter("bookdate", ">=", CalendarUtils.getStartDate(startdate)));
        }
        if (enddate != null) {
            filters.add(new ModelFilter("bookdate", "<=", CalendarUtils.getEndDate(enddate)));
        }
        return filters;
    }

    private Map<String, Set<Long>> createBillIds(Set<String> billTypeNums, DataSet logsData) {
        DataSet copyLogs = logsData.copy();
        HashMap<String, Set<Long>> settleBillIds = new HashMap<String, Set<Long>>(16);
        while (copyLogs.hasNext()) {
            Row row = copyLogs.next();
            Long billId = row.getLong("settlebillid");
            String billEntityType = row.getString("settlebilltype");
            if (StringUtils.isEmpty((CharSequence)billEntityType)) continue;
            CommonUtils.mapGetSetValue(settleBillIds, billEntityType).add(billId);
        }
        return settleBillIds;
    }

    private void loadRowEntry(TableValueSetter vs, Row row, String ... fieldNames) {
        for (String field : fieldNames) {
            if ("createdate".equals(field)) {
                vs.addField("settletime", new Object[]{row.get(field)});
                continue;
            }
            vs.addField(field, new Object[]{row.get(field)});
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        switch (key = event.getProperty().getName()) {
            case "balanceorg_q": 
            case "oppositeorg_q": {
                this.beforeSelectOrg(event);
            }
        }
    }

    private void beforeSelectOrg(BeforeF7SelectEvent event) {
        ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
        List qFilters = param.getListFilterParameter().getQFilters();
        List<QFilter> collect = qFilters.stream().filter(f -> !"id = -1".equals(f.toString())).collect(Collectors.toList());
        this.addPermissionOrg(collect);
        param.getListFilterParameter().setQFilters(collect);
    }

    private void addPermissionOrg(List<QFilter> collect) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)"ism_interorgsettleform", (String)"10");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (Map tempOrg : hasPermissionOrgs) {
            if (((String)tempOrg.get("id")).equals("9999999999999")) continue;
            orgIds.add(Long.parseLong((String)tempOrg.get("id")));
        }
        collect.add(new QFilter("id", "in", orgIds));
    }

    public void hyperLinkClick(HyperLinkClickEvent paramEvent) {
        String fieldName = paramEvent.getFieldName();
        int row = paramEvent.getRowIndex();
        switch (fieldName) {
            case "sourcenum": {
                this.showSrcBill(row, "sourceid", "sourcetype");
                break;
            }
            case "number": {
                this.showSrcBill(row, "settlebillid", "settlebilltype");
            }
        }
    }

    private void showSrcBill(int row, String billIdKey, String billTypeKey) {
        DynamicObject singleEntry = this.getModel().getEntryRowEntity("entryentity", row);
        long billId = singleEntry.getLong(billIdKey);
        String billTpye = singleEntry.getDynamicObject(billTypeKey).getString("number");
        PageShowHelper.showBillEdit(this.getView(), billTpye, (Object)billId);
    }
}

