/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.dynpage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.EntityOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.scmc.ism.business.helper.BillFieldMappingDataHelper;
import kd.scmc.ism.business.helper.BillModelDataSetHelper;
import kd.scmc.ism.business.helper.BizConfigHelper;
import kd.scmc.ism.business.helper.BotpLinkHelper;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.business.helper.filter.CommonF7SelectFilterHelper;
import kd.scmc.ism.business.helper.filter.CommonFilterHelper;
import kd.scmc.ism.business.utils.BizLockUtils;
import kd.scmc.ism.business.utils.CalendarUtils;
import kd.scmc.ism.common.consts.config.SettleLogConsts;
import kd.scmc.ism.common.model.entity.ModelFilter;
import kd.scmc.ism.common.model.handler.BillFieldMapCfg;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.control.DataRangeUtils;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.common.utils.control.MulComboUtils;
import kd.scmc.ism.formplugin.template.AbstractISMDynBillFormPlugin;
import kd.scmc.ism.lang.FormLang;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.model.batexec.BizBatchProcessor;
import kd.scmc.ism.model.batexec.handle.impl.SettleBizAsyncExecutor;
import kd.scmc.ism.model.batexec.handle.impl.SettleBizExcutor;
import kd.scmc.ism.model.batexec.handle.impl.UnSettleBizAsyncExecutor;
import kd.scmc.ism.model.batexec.handle.impl.UnSettleBizExcutor;
import kd.scmc.ism.task.utils.TaskHelper;

public class ProcessCenterFormPlugin
extends AbstractISMDynBillFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ProcessCenterFormPlugin.class);
    private static final String[] settleLogheadfields = new String[]{"id as logid", "sourceid", "sourcenum", "sourcetype", "billfailcause", "entryentity.settlerelation as settlerelation", "entryentity.supsettleorg as suporg", "entryentity.oppositeorg as demorg", "createstatus", "createdate"};
    private static final int HUNDRED = 100;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, "balanceorg_q", "oppositeorg_q");
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        MulComboEdit billType = (MulComboEdit)this.getView().getControl("billtypebiz");
        MulComboUtils.fillsWithBill(BizConfigHelper.getEnableBFMBillObjs(), billType);
        DataRangeUtils.setOneMonth(this.getModel(), "daterange_startdate", "daterange_enddate");
        DataRangeUtils.setOneMonth(this.getModel(), "settledaterange_startdate", "settledaterange_enddate");
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String opKey;
        super.afterDoOperation(event);
        switch (opKey = event.getOperateKey()) {
            case "innersettlebill": {
                this.doInnerSettleBillQuery(event);
                break;
            }
            case "arorapsettlebill": {
                this.doArApSettleBillQuery(event);
                break;
            }
            case "settle": 
            case "settleasync": 
            case "unsettle": 
            case "unsettleasync": 
            case "releaselock": 
            case "settlepro": 
            case "settleproasync": 
            case "unsettlepro": 
            case "unsettleproasync": {
                this.doInnerSettleBiz(opKey);
                break;
            }
            case "dorefresh": {
                this.doQuery(event);
                break;
            }
            case "cacheclear": {
                TaskHelper.removeAllAppCache();
                break;
            }
        }
    }

    @Override
    protected void doQuery(AfterDoOperationEventArgs event) {
        if (this.getBalanceOrgIds().isEmpty() && this.getOppositeOrgIds().isEmpty()) {
            this.getView().showTipNotification(FormLang.noInputOrgInfo());
            return;
        }
        int pageIndex = this.getCurrentPageIndex();
        this.getModel().deleteEntryData("entryentity");
        DataSet logInfoDS = this.getSettleLogDS();
        if (logInfoDS == null || logInfoDS.isEmpty()) {
            this.getView().showTipNotification(FormLang.noQueryData());
            return;
        }
        Map<String, Set<Long>> billIdsMap = this.splitSourceBills(logInfoDS);
        if (billIdsMap.isEmpty()) {
            this.getView().showTipNotification(FormLang.noQueryData());
            return;
        }
        DataSet parallelGetData = BillModelDataSetHelper.parallelGetDataWithModelFilter(billIdsMap, BillFieldMapCfg.buildAll(), new String[]{"biztype", "biztime", "bookdate"}, this.getBillModelFilter());
        int maxCount = this.getMaxQueryCount();
        DataSet result = logInfoDS.join(parallelGetData, JoinType.INNER).on("sourceid", "billid").select(logInfoDS.getRowMeta().getFieldNames(), parallelGetData.getRowMeta().getFieldNames()).finish().orderBy(new String[]{"biztime desc", "billno desc"}).top(maxCount);
        if (result.isEmpty()) {
            this.getView().showTipNotification(FormLang.noQueryData());
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        while (result.hasNext()) {
            Row row = result.next();
            vs.addField("settlerelation", new Object[]{row.getLong("settlerelation")});
            vs.addField("settlelogid", new Object[]{row.get("logid")});
            vs.addField("biztype", new Object[]{row.get("biztype")});
            vs.addField("biztime", new Object[]{row.get("biztime")});
            vs.addField("bookdate", new Object[]{row.get("bookdate")});
            vs.addField("settletime", new Object[]{row.get("createdate")});
            vs.addField("suporg", new Object[]{row.get("suporg")});
            vs.addField("demorg", new Object[]{row.get("demorg")});
            vs.addField("billtype", new Object[]{row.get("sourcetype")});
            vs.addField("number", new Object[]{row.get("sourcenum")});
            vs.addField("billnum", new Object[]{row.get("sourcetype")});
            vs.addField("billid", new Object[]{row.get("sourceid")});
            String createStatus = row.getString("createstatus");
            vs.addField("iscreatebill", new Object[]{"A".equals(createStatus)});
            vs.addField("settleresult", new Object[]{createStatus});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        OperateOption option = ((FormOperate)event.getSource()).getOption();
        String opParam = option.getVariableValue("opKey", "");
        if (StringUtils.isEmpty((CharSequence)opParam)) {
            opParam = event.getOperateKey();
        }
        this.setCurrentPageIndex(opParam, pageIndex);
        this.getView().updateView("entryentity");
    }

    private int getMaxQueryCount() {
        int size = 100000;
        DynamicObject param = QueryServiceHelper.queryOne((String)"im_invdbparam", (String)"id,value", (QFilter[])new QFilter("key", "=", (Object)"ism_maxquerycount").toArray());
        if (param != null) {
            String value = param.getString("value");
            try {
                size = Integer.parseInt(value);
            }
            catch (Exception e) {
                log.info("\u6570\u636e\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u53f0\u53c2\u6570ism_maxquerycount\u914d\u7f6e\u7684\u503c\u662f\u5426\u6b63\u786e\u3002");
                log.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        return size > 100000 ? 100000 : size;
    }

    private DataSet getSettleLogDS() {
        Set<Long> oppositeOrgIds;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        QFilter orgfilter = CommonFilterHelper.getAllFilter();
        Set<Long> balanceOrgIds = this.getBalanceOrgIds();
        if (CommonUtils.collectionIsNotEmpty(balanceOrgIds)) {
            orgfilter.and(new QFilter(SettleLogConsts.getSettleLogInfo("supsettleorg"), "in", balanceOrgIds));
        }
        if (CommonUtils.collectionIsNotEmpty(oppositeOrgIds = this.getOppositeOrgIds())) {
            orgfilter.and(SettleLogConsts.getSettleLogInfo("oppositeorg"), "in", oppositeOrgIds);
        }
        Date startDate = (Date)this.getModel().getValue("settledaterange_startdate");
        Date endDate = (Date)this.getModel().getValue("settledaterange_enddate");
        filters.add(this.getSettleDateFilter(startDate, endDate));
        filters.add(orgfilter.or("createstatus", "=", (Object)"U"));
        String settleStatusStr = (String)this.getModel().getValue("settlestatus");
        if (!StringUtils.isEmpty((CharSequence)settleStatusStr)) {
            List<String> settleStatus = MulComboUtils.getMultiCombValue(settleStatusStr, new String[0]);
            filters.add(new QFilter("createstatus", "in", settleStatus));
        }
        filters.add(CommonFilterHelper.getFromToFilter("sourcenum", (String)this.getModel().getValue("billnofrom"), (String)this.getModel().getValue("billnoto")));
        String billTypeStr = (String)this.getModel().getValue("billtypebiz");
        List<String> billTypes = MulComboUtils.getMultiCombValue(billTypeStr, new String[0]);
        if (CommonUtils.collectionIsEmpty(billTypes)) {
            billTypes.addAll(BizConfigHelper.getEnableSettleJudgeBills());
        }
        filters.add(new QFilter("sourcetype", "in", billTypes));
        String selectedFields = BillFieldMappingDataHelper.billFieldsToStr(settleLogheadfields);
        DataSet logInfoDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ism_settlelog", (String)selectedFields, (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"");
        logInfoDS = logInfoDS.groupBy(logInfoDS.getRowMeta().getFieldNames()).finish();
        return logInfoDS;
    }

    private List<ModelFilter> getBillModelFilter() {
        ArrayList<ModelFilter> billFilter = new ArrayList<ModelFilter>(4);
        IDataModel model = this.getModel();
        Date bizStartdate = (Date)model.getValue("daterange_startdate");
        Date bizEnddate = (Date)model.getValue("daterange_enddate");
        if (bizStartdate != null) {
            billFilter.add(new ModelFilter("bookdate", ">=", CalendarUtils.getStartDate(bizStartdate)));
        }
        if (bizEnddate != null) {
            billFilter.add(new ModelFilter("bookdate", "<=", CalendarUtils.getEndDate(bizEnddate)));
        }
        return billFilter;
    }

    private Map<String, Set<Long>> splitSourceBills(DataSet logInfoDS) {
        HashMap<String, Set<Long>> billIdsMap = new HashMap<String, Set<Long>>(16);
        DataSet copyLog = logInfoDS.copy();
        while (copyLog.hasNext()) {
            Row next = copyLog.next();
            String sourceBillType = next.getString("sourcetype");
            Long sourceBillId = next.getLong("sourceid");
            HashSet<Long> billIds = (HashSet<Long>)billIdsMap.get(sourceBillType);
            if (billIds == null) {
                billIds = new HashSet<Long>(16);
                billIdsMap.put(sourceBillType, billIds);
            }
            billIds.add(sourceBillId);
        }
        return billIdsMap;
    }

    private Set<Long> getOppositeOrgIds() {
        DynamicObjectCollection oppositeorg_q = (DynamicObjectCollection)this.getModel().getValue("oppositeorg_q");
        Set<Long> oppositeOrgIds = oppositeorg_q.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toSet());
        return oppositeOrgIds;
    }

    private Set<Long> getBalanceOrgIds() {
        DynamicObjectCollection balanceorg_q = (DynamicObjectCollection)this.getModel().getValue("balanceorg_q");
        Set<Long> balanceOrgIds = balanceorg_q.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toSet());
        return balanceOrgIds;
    }

    private void doInnerSettleBillQuery(AfterDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length != 1) {
            this.getView().showTipNotification(FormLang.plsSelectOneBillCheck());
            return;
        }
        int rowIndex = rows[0];
        Long billId = (Long)this.getModel().getValue("billid", rowIndex);
        String billnum = (String)this.getModel().getValue("billnum", rowIndex);
        Long logId = (Long)this.getModel().getValue("settlelogid", rowIndex);
        QFilter logFilter = new QFilter("id", "=", (Object)logId);
        String settleBillIdField = "entryentity.settlebillid";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ism_settlelog", (String)settleBillIdField, (QFilter[])logFilter.toArray());
        HashSet<Long> settleBillIds = new HashSet<Long>(query.size());
        for (DynamicObject settleBillLog : query) {
            long settleBillId = settleBillLog.getLong(settleBillIdField);
            settleBillIds.add(settleBillId);
        }
        List<BFRowLinkDownNode> nodes = BFTrackerServiceHelper.loadLinkDownNodes((String)billnum, (String)"", (Long[])new Long[]{billId});
        if (CommonUtils.collectionIsEmpty(nodes = BotpLinkHelper.getSpecBillIds(settleBillIds, nodes))) {
            this.getView().showTipNotification(FormLang.notGenerateInnerSettleBill());
            return;
        }
        EntityOperate source = (EntityOperate)e.getSource();
        PageShowHelper.showLookDownPage(this.getView(), source.getOperateName().getLocaleValue(), nodes);
    }

    private void doArApSettleBillQuery(AfterDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length != 1) {
            String message = FormLang.plsSelectOneBillCheck();
            this.getView().showTipNotification(message);
            return;
        }
        int rowIndex = rows[0];
        Long logId = (Long)this.getModel().getValue("settlelogid", rowIndex);
        QFilter logFilter = new QFilter("id", "=", (Object)logId);
        String settleBillIdField = "entryentity.settlebillid";
        String settleBillTypeFiled = "entryentity.settlebilltype";
        String selectFields = BillFieldMappingDataHelper.billFieldsToStr(new String[]{settleBillIdField, settleBillTypeFiled});
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ism_settlelog", (String)selectFields, (QFilter[])logFilter.toArray());
        HashMap<String, ArrayList<Long>> settleBillIds = new HashMap<String, ArrayList<Long>>(query.size());
        for (Object settleBillLog : query) {
            long l = settleBillLog.getLong(settleBillIdField);
            String settleBillType = settleBillLog.getString(settleBillTypeFiled);
            ArrayList<Long> billIds = (ArrayList<Long>)settleBillIds.get(settleBillType);
            if (billIds == null) {
                billIds = new ArrayList<Long>();
                settleBillIds.put(settleBillType, billIds);
            }
            billIds.add(l);
        }
        List<BFRowLinkDownNode> nodes = new ArrayList<BFRowLinkDownNode>(settleBillIds.size());
        for (Map.Entry entry : settleBillIds.entrySet()) {
            List billIds = (List)entry.getValue();
            nodes.addAll(BFTrackerServiceHelper.loadLinkDownNodes((String)((String)entry.getKey()), (String)"", (Long[])billIds.toArray(new Long[billIds.size()])));
        }
        Set<Long> tableIds = BotpLinkHelper.getArApTableDefines();
        if (CommonUtils.collectionIsEmpty(nodes = BotpLinkHelper.getSpecBillType(nodes, tableIds))) {
            this.getView().showTipNotification(FormLang.notGenerateARorAP());
        } else {
            EntityOperate entityOperate = (EntityOperate)e.getSource();
            PageShowHelper.showLookDownPage(this.getView(), entityOperate.getOperateName().getLocaleValue(), nodes);
        }
    }

    private void doInnerSettleBiz(String opKey) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length < 1) {
            this.getView().showTipNotification(FormLang.PlsSelectExcuteData());
            return;
        }
        HashMap<Long, String> IdToBillNos = new HashMap<Long, String>(16);
        HashMap<String, List<Long>> billIdsInfo = new HashMap<String, List<Long>>(16);
        for (int rowIndex : rows) {
            String billType = (String)this.getModel().getValue("billnum", rowIndex);
            Long billId = (Long)this.getModel().getValue("billid", rowIndex);
            String billno = (String)this.getModel().getValue("number", rowIndex);
            IdToBillNos.put(billId, billno);
            CommonUtils.mapGetListValue(billIdsInfo, billType).add(billId);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("opKey", opKey);
        if ("settle".equals(opKey)) {
            if (rows.length > 100) {
                this.asyncSettle(billIdsInfo);
            } else {
                this.syncSettle(IdToBillNos, billIdsInfo);
            }
        } else if ("settleasync".equals(opKey)) {
            this.asyncSettle(billIdsInfo);
        } else if ("unsettle".equals(opKey)) {
            this.dataFilter(IdToBillNos);
            if (IdToBillNos.isEmpty()) {
                this.getView().showTipNotification(FormLang.notAllowUnsettle());
                return;
            }
            if (rows.length > 100) {
                this.asyncUnSettle(IdToBillNos.keySet());
            } else {
                this.syncUnSettle(IdToBillNos);
            }
        } else if ("unsettleasync".equals(opKey)) {
            this.dataFilter(IdToBillNos);
            if (IdToBillNos.isEmpty()) {
                this.getView().showTipNotification(FormLang.notAllowUnsettle());
                return;
            }
            this.asyncUnSettle(IdToBillNos.keySet());
        } else if ("releaselock".equals(opKey)) {
            BizLockUtils.releaseLock(IdToBillNos.keySet(), "SETTLE");
            this.getView().showSuccessNotification(FormLang.releaseLockFinish());
        } else if ("settlepro".equals(opKey)) {
            if (rows.length > 100) {
                this.asyncSettleWithProgress();
            } else {
                this.syncSettleWithDataFilter();
            }
        } else if ("settleproasync".equals(opKey)) {
            this.asyncSettleWithProgress();
        } else if ("unsettlepro".equals(opKey)) {
            if (rows.length > 100) {
                this.asyncUnSettle();
            } else {
                this.syncUnSettle();
            }
        } else if ("unsettleproasync".equals(opKey)) {
            this.asyncUnSettle();
        }
        this.getView().invokeOperation("queryap", option);
    }

    private void asyncSettle(Map<String, List<Long>> billIdsInfo) {
        for (Map.Entry<String, List<Long>> billInfoEntry : billIdsInfo.entrySet()) {
            BizBatchProcessor<Long, String> processor = new BizBatchProcessor<Long, String>(new SettleBizAsyncExecutor(billInfoEntry.getKey()));
            processor.addAllAndExec((Collection<Long>)billInfoEntry.getValue());
            processor.doProcess();
        }
        this.getView().showSuccessNotification(FormLang.turnToBackRuning());
    }

    private void syncSettle(Map<Long, String> IdToBillNos, Map<String, List<Long>> billIdsInfo) {
        ArrayList<SettleOperResult> allResults = new ArrayList<SettleOperResult>(16);
        for (Map.Entry<String, List<Long>> billInfoEntry : billIdsInfo.entrySet()) {
            BizBatchProcessor<Long, SettleOperResult> processor = new BizBatchProcessor<Long, SettleOperResult>(new SettleBizExcutor(billInfoEntry.getKey()));
            processor.addAllAndExec((Collection<Long>)billInfoEntry.getValue());
            allResults.addAll(processor.doProcess());
        }
        this.showSettleInfo(allResults, IdToBillNos);
    }

    private void asyncUnSettle(Set<Long> billId) {
        BizBatchProcessor<Long, String> processor = new BizBatchProcessor<Long, String>(new UnSettleBizAsyncExecutor());
        processor.addAllAndExec(billId);
        processor.doProcess();
        this.getView().showSuccessNotification(FormLang.turnToBackRuning());
    }

    private void syncUnSettle(Map<Long, String> IdToBillNos) {
        BizBatchProcessor<Long, SettleOperResult> processor = new BizBatchProcessor<Long, SettleOperResult>(new UnSettleBizExcutor());
        processor.addAllAndExec(IdToBillNos.keySet());
        List<SettleOperResult> allResults = processor.doProcess();
        this.showSettleInfo(allResults, IdToBillNos);
    }

    private void showSettleInfo(List<SettleOperResult> allResults, Map<Long, String> idToBillNos) {
        SettleOperResult result = new SettleOperResult();
        for (SettleOperResult operResult : allResults) {
            result.combine(operResult);
        }
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ModelLang.settleSuccess());
        } else {
            Map<Long, String> failReasons = result.getFailReasons();
            HashMap<String, Object> billFailInfo = new HashMap<String, Object>(failReasons.size());
            for (Map.Entry<Long, String> info : failReasons.entrySet()) {
                billFailInfo.put(idToBillNos.get(info.getKey()), info.getValue());
            }
            PageShowHelper.showOperResult(this.getView(), billFailInfo);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        switch (key = event.getProperty().getName()) {
            case "balanceorg_q": 
            case "oppositeorg_q": {
                QFilter qFilter = CommonF7SelectFilterHelper.getPermissionOrg("ism_processcenter");
                FormUtils.setF7Filter(event, qFilter);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent paramEvent) {
        String fieldName = paramEvent.getFieldName();
        int row = paramEvent.getRowIndex();
        switch (fieldName) {
            case "settleresult": {
                this.showSettleLog(row);
                break;
            }
            case "number": {
                this.showSrcBill(row);
                break;
            }
        }
    }

    private void showSrcBill(int row) {
        DynamicObject singleEntry = this.getModel().getEntryRowEntity("entryentity", row);
        long billId = singleEntry.getLong("billid");
        String billTpye = singleEntry.getString("billnum");
        PageShowHelper.showBillEdit(this.getView(), billTpye, (Object)billId);
    }

    private void dataFilter(Map<Long, String> IdToBillNos) {
        int[] rows;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        for (int rowIndex : rows = entryGrid.getSelectRows()) {
            String settleResult = (String)this.getModel().getValue("settleresult", rowIndex);
            if (!"U".equals(settleResult)) continue;
            Long billId = (Long)this.getModel().getValue("billid", rowIndex);
            IdToBillNos.remove(billId);
        }
    }

    private void showSettleLog(int row) {
        DynamicObject singleEntry = this.getModel().getEntryRowEntity("entryentity", row);
        PageShowHelper.showBaseEdit(this.getView(), "ism_settlelog", singleEntry.getLong("settlelogid"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "billnofrom": {
                this.changeBillNoFrom(e, "billnoto");
                break;
            }
        }
    }

    private void syncSettleWithDataFilter() {
        HashMap<String, List<Long>> billIdsInfo = new HashMap<String, List<Long>>(16);
        HashMap<Long, String> IdToBillNos = new HashMap<Long, String>(16);
        this.settleDataFilter(billIdsInfo, IdToBillNos);
        if (billIdsInfo.isEmpty() || IdToBillNos.isEmpty()) {
            this.getView().showTipNotification(FormLang.notAllowSettle());
            return;
        }
        this.syncSettle(IdToBillNos, billIdsInfo);
    }

    private void asyncSettleWithProgress() {
        String traceId = RequestContext.get().getTraceId();
        if (this.settleCheck()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u4efb\u52a1\u6570\u5df2\u8d85\u8fc7\u5141\u8bb8\u6570\u91cf\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ProcessCenterFormPlugin_3", (String)"scmc-ism-form", (Object[])new Object[0]));
            return;
        }
        HashMap<String, List<Long>> billIdsInfo = new HashMap<String, List<Long>>(128);
        HashMap<Long, String> billIdToNo = new HashMap<Long, String>(128);
        this.settleDataFilter(billIdsInfo, billIdToNo);
        if (billIdsInfo.isEmpty() || billIdToNo.isEmpty()) {
            this.getView().showTipNotification(FormLang.notAllowSettle());
            return;
        }
        int total = 0;
        for (List list : billIdsInfo.values()) {
            total += list.size();
        }
        this.showSettleProgressForm(billIdsInfo, billIdToNo, total, "settle", traceId);
    }

    private void settleDataFilter(Map<String, List<Long>> billInfo, Map<Long, String> idToBillNo) {
        int[] rows;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        for (int rowIndex : rows = entryGrid.getSelectRows()) {
            String status = (String)this.getModel().getValue("settleresult", rowIndex);
            if ("A".equals(status)) continue;
            String billType = (String)this.getModel().getValue("billnum", rowIndex);
            Long billId = (Long)this.getModel().getValue("billid", rowIndex);
            String billNo = (String)this.getModel().getValue("number", rowIndex);
            idToBillNo.put(billId, billNo);
            CommonUtils.mapGetListValue(billInfo, billType).add(billId);
        }
    }

    private void syncUnSettle() {
        Map<Long, String> idToBillNo = this.getUnSettleData();
        if (idToBillNo.isEmpty()) {
            this.getView().showTipNotification(FormLang.notAllowUnsettle());
            return;
        }
        BizBatchProcessor<Long, SettleOperResult> processor = new BizBatchProcessor<Long, SettleOperResult>(new UnSettleBizExcutor());
        processor.addAllAndExec(idToBillNo.keySet());
        List<SettleOperResult> allResults = processor.doProcess();
        this.showSettleInfo(allResults, idToBillNo);
    }

    private void asyncUnSettle() {
        if (this.settleCheck()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u4efb\u52a1\u6570\u5df2\u8d85\u8fc7\u5141\u8bb8\u6570\u91cf\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ProcessCenterFormPlugin_3", (String)"scmc-ism-form", (Object[])new Object[0]));
            return;
        }
        Map<Long, String> idToBillNo = this.getUnSettleData();
        if (idToBillNo.isEmpty()) {
            this.getView().showTipNotification(FormLang.notAllowUnsettle());
            return;
        }
        ArrayList<Long> billIds = new ArrayList<Long>(idToBillNo.keySet());
        this.showSettleProgressForm(billIds, idToBillNo, billIds.size(), "unsettle", RequestContext.get().getTraceId());
    }

    private Map<Long, String> getUnSettleData() {
        int[] rows;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        HashMap<Long, String> data = new HashMap<Long, String>(128);
        for (int rowIndex : rows = entryGrid.getSelectRows()) {
            String status = (String)this.getModel().getValue("settleresult", rowIndex);
            if (!"A".equals(status) && !"E".equals(status) && !"B".equals(status) && !"W".equals(status)) continue;
            String billNo = (String)this.getModel().getValue("number", rowIndex);
            Long billId = (Long)this.getModel().getValue("billid", rowIndex);
            data.put(billId, billNo);
        }
        return data;
    }

    private void showSettleProgressForm(Object billIdsInfo, Map<Long, String> billIdToNo, int total, String opType, String traceId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ism_settle_progress");
        showParameter.setAppId("ism");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("billInfo", SerializationUtils.toJsonString((Object)billIdsInfo));
        params.put("total", total);
        params.put("optype", opType);
        params.put("traceid", traceId);
        params.put("billno", SerializationUtils.toJsonString(billIdToNo));
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    private boolean settleCheck() {
        int maxSize = TaskHelper.getMaxHandleSize();
        IAppCache cache = AppCache.get((String)"ism_settle_key_trace_id");
        List cacheList = (List)cache.get("cache_traceid", List.class);
        if (cacheList != null && !cacheList.isEmpty()) {
            List taskInfos = ScheduleServiceHelper.queryTask((List)cacheList);
            for (TaskInfo taskInfo : taskInfos) {
                if (!taskInfo.isTaskEnd()) continue;
                cacheList.remove(taskInfo.getId());
            }
            cache.put("cache_traceid", (Object)cacheList);
            if (cacheList.size() >= maxSize) {
                return true;
            }
        }
        return false;
    }
}

