/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.dynpage.validate;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.selectlistener.billmainentity.BillEnableBFM;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.formplugin.template.AbstractISMFormPlugin;
import kd.scmc.ism.lang.FormLang;
import kd.scmc.ism.mservice.settlebill.SettlePriceRuleServiceImpl;

public class ServiceValidateEdit
extends AbstractISMFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"dobatchprice", "dobillprice"});
        FormUtils.addF7Listener(BillEnableBFM.getInstance(), this, "billtype");
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = FormUtils.getControlEventKey(evt)) {
            case "dobatchprice": {
                this.doBatchPrice();
                break;
            }
            case "dobillprice": {
                this.doBillPrice();
                break;
            }
        }
    }

    private void doBillPrice() {
        Map<String, DynamicObject> billNoToMap = this.getBillNoInfos();
        String billEntity = ((DynamicObject)this.getValue("billtype")).getString("number");
        DynamicObjectCollection billInfos = QueryServiceHelper.query((String)billEntity, (String)"id,billno", (QFilter[])new QFilter("billno", "in", billNoToMap.keySet()).toArray());
        if (billInfos.isEmpty()) {
            throw new KDBizException(FormLang.curBillNotExist());
        }
        ArrayList<Long> params = new ArrayList<Long>(16);
        for (DynamicObject bill : billInfos) {
            long billId = bill.getLong("id");
            params.add(billId);
        }
        SettlePriceRuleServiceImpl service = new SettlePriceRuleServiceImpl();
        Map<Long, Map<String, Object>> batchDoPricing = service.doBillPricing(billEntity, params);
        this.getView().showMessage(batchDoPricing.toString());
    }

    private void doBatchPrice() {
        Map<String, DynamicObject> billNoToMap = this.getBillNoInfos();
        String billEntity = ((DynamicObject)this.getValue("billtype")).getString("number");
        DynamicObjectCollection billInfos = QueryServiceHelper.query((String)billEntity, (String)"id,billno", (QFilter[])new QFilter("billno", "in", billNoToMap.keySet()).toArray());
        if (billInfos.isEmpty()) {
            throw new KDBizException(FormLang.curBillNotExist());
        }
        ArrayList<Map<String, Long>> params = new ArrayList<Map<String, Long>>(16);
        for (DynamicObject bill : billInfos) {
            long billId = bill.getLong("id");
            String billNo = bill.getString("billno");
            DynamicObject entryObj = billNoToMap.get(billNo);
            long supplierId = DynamicObjectUtil.getPkValue(entryObj.getDynamicObject("supplierorg"));
            long demandId = DynamicObjectUtil.getPkValue(entryObj.getDynamicObject("demandorg"));
            HashMap<String, Long> param = new HashMap<String, Long>();
            param.put("id", billId);
            param.put("supid", supplierId);
            param.put("demid", demandId);
            params.add(param);
        }
        SettlePriceRuleServiceImpl service = new SettlePriceRuleServiceImpl();
        Map<Long, Map<String, Object>> batchDoPricing = service.batchDoPricing(billEntity, params);
        this.getView().showMessage(batchDoPricing.toString());
    }

    private Map<String, DynamicObject> getBillNoInfos() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billlist");
        HashMap<String, DynamicObject> billNoToMap = new HashMap<String, DynamicObject>(16);
        ArrayList<String> eptSeq = new ArrayList<String>(16);
        for (DynamicObject entry : entryEntity) {
            String billNos = entry.getString("billno");
            if (StringUtils.isNotEmpty((CharSequence)billNos)) {
                billNoToMap.put(billNos, entry);
                continue;
            }
            eptSeq.add(entry.getString("seq"));
        }
        if (!eptSeq.isEmpty()) {
            throw new KDBizException(FormLang.plsInputBillNo(((Object)eptSeq).toString()));
        }
        return billNoToMap;
    }
}

