/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.generate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.scmc.ism.business.helper.InputConstsHelper;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.business.selectlistener.billmainentity.BillEnableBFM;
import kd.scmc.ism.common.model.args.InputConstsResult;
import kd.scmc.ism.common.selectstrategy.SettleRelationsStrategy;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.formplugin.template.AbstractColSelectEdit;
import kd.scmc.ism.lang.FormLang;
import org.apache.commons.lang.StringUtils;

public class BillFieldResetRuleEdit
extends AbstractColSelectEdit {
    private static final String SELECT_TARGET_BILLFIELD_CB = "selectBillFieldCB";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"constantsdesc", "targetfiledname"});
        FormUtils.addF7Listener(BillEnableBFM.getInstance(), this, "targetbill");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setTargetBillEnable();
    }

    private void setTargetBillEnable() {
        DynamicObject data = this.getModel().getDataEntity();
        if (data.getLong("id") == 0L) {
            return;
        }
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        BaseDataCheckRefrenceResult refrenceResult = checker.checkRef((BasedataEntityType)data.getDataEntityType(), data.getPkValue());
        boolean isRefrence = refrenceResult.isRefence();
        if (isRefrence) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"targetbill"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "targetbill": {
                this.getModel().deleteEntryData("entryentity");
                break;
            }
            case "targetfiledname": {
                this.changeTargetFieldKey(e);
            }
        }
    }

    private void changeTargetFieldKey(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        model.beginInit();
        for (ChangeData changeData : changeSet) {
            int rowIndex = changeData.getRowIndex();
            model.setValue("targetfiledkey", null, rowIndex);
            model.setValue("constants", null, rowIndex);
            model.setValue("constantsdesc", null, rowIndex);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = FormUtils.getControlEventKey(evt)) {
            case "constantsdesc": {
                this.clickConstants();
                break;
            }
            case "targetfiledname": {
                this.clickTargetBillName();
                break;
            }
        }
    }

    private void clickConstants() {
        IDataModel model = this.getModel();
        DynamicObject targetBill = (DynamicObject)this.getModel().getValue("targetbill");
        if (CommonUtils.isNull(targetBill)) {
            this.getView().showTipNotification(FormLang.plsSelectTargetBillObj());
            return;
        }
        int index = model.getEntryCurrentRowIndex("entryentity");
        String fieldKey = (String)model.getValue("targetfiledkey", index);
        if (StringUtils.isEmpty((String)fieldKey)) {
            this.getView().showTipNotification(FormLang.plsSelectTargetField());
            return;
        }
        fieldKey = this.getFieldKey(fieldKey);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)targetBill.getString("number"));
        IDataEntityProperty prop = entityType.findProperty(fieldKey);
        InputConstsHelper.showInputConsts((IFormPlugin)this, this.getView(), prop);
    }

    private void clickTargetBillName() {
        DynamicObject targetBill = (DynamicObject)this.getModel().getValue("targetbill");
        if (targetBill == null) {
            this.getView().showTipNotification(FormLang.plsSelectTargetBillObj());
            return;
        }
        PageShowHelper.showSelectColsPage(this.getView(), targetBill.getString("number"), new SettleRelationsStrategy(), null, new CloseCallBack((IFormPlugin)this, SELECT_TARGET_BILLFIELD_CB));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        IDataModel model = this.getModel();
        model.beginInit();
        if (SELECT_TARGET_BILLFIELD_CB.equals(sourceFldKey)) {
            String selectField = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isNotEmpty((String)selectField)) {
                JSONArray array = JSON.parseArray((String)selectField);
                if (array.isEmpty()) {
                    return;
                }
                JSONObject jsonObject = array.getJSONObject(0);
                this.showTargetBillField(jsonObject.getString("id"), jsonObject.getString("text"));
            }
        } else {
            InputConstsResult inputConstsResult = InputConstsHelper.getInputConstsResult(closedCallBackEvent);
            if (inputConstsResult != null) {
                int rowIndex = model.getEntryCurrentRowIndex("entryentity");
                model.setValue("constantsdesc", (Object)inputConstsResult.getConstsDes(), rowIndex);
                model.setValue("constants", (Object)inputConstsResult.getConsts(), rowIndex);
            }
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void showTargetBillField(Object resultKey, Object resultName) {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        model.setValue("targetfiledkey", resultKey, rowIndex);
        model.setValue("targetfiledname", resultName, rowIndex);
        model.setValue("constants", null, rowIndex);
        model.setValue("constantsdesc", null, rowIndex);
    }
}

