/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.progress;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scmc.ism.business.helper.JobHelper;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.formplugin.progress.TaskClick;
import kd.scmc.ism.formplugin.progress.TaskFinishCallBack;
import kd.scmc.ism.model.batexec.BizBatchProcessor;
import kd.scmc.ism.model.batexec.handle.impl.SettleBizAsyncExecutor;
import kd.scmc.ism.model.batexec.handle.impl.UnSettleBizAsyncExecutor;
import kd.scmc.ism.task.InnerSettleExecuteTask;
import kd.scmc.ism.task.InnerUnSettleExecuteTask;
import kd.scmc.ism.task.utils.TaskHelper;

public class SettleProgressFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public void registerListener(EventObject e) {
        Button btnOk;
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbar");
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
        if ((btnOk = (Button)this.getControl("btnok")) != null) {
            btnOk.addClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object opType;
        super.afterCreateNewData(e);
        Object total = this.getView().getFormShowParameter().getCustomParam("total");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"successpanel", "failpanel"});
        if (total != null) {
            this.getModel().setValue("total", total);
        }
        if ((opType = this.getView().getFormShowParameter().getCustomParam("optype")) != null) {
            if ("settle".equals(opType)) {
                this.setLabelText(ResManager.loadKDString((String)"\u7ed3\u7b97\u6210\u529f\u7684\u5355\u636e", (String)"SettleProgressFormPlugin_0", (String)"scmc-ism-form", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u7b97\u5931\u8d25\u7684\u5355\u636e", (String)"SettleProgressFormPlugin_1", (String)"scmc-ism-form", (Object[])new Object[0]));
            } else if ("unsettle".equals(opType)) {
                this.setLabelText(ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u6210\u529f\u7684\u5355\u636e", (String)"SettleProgressFormPlugin_2", (String)"scmc-ism-form", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\u7684\u5355\u636e", (String)"SettleProgressFormPlugin_3", (String)"scmc-ism-form", (Object[])new Object[0]));
            }
        }
        this.startBar();
        String taskId = this.getTaskId();
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            this.setPageFieldValue(taskInfo.getData());
            int progress = taskInfo.getProgress();
            if (taskInfo.isTaskEnd()) {
                this.setComplete();
            }
            ProgressBar bar = (ProgressBar)this.getControl("progressbar");
            bar.setPercent(progress);
        }
    }

    private void setLabelText(String text1, String text2) {
        Label successLabel = (Label)this.getControl("successlabel");
        Label failLabel = (Label)this.getControl("faillabel");
        successLabel.setText(text1);
        failLabel.setText(text2);
    }

    public void onProgress(ProgressEvent evt) {
        boolean start = this.isStart();
        this.setStart(true);
        String taskId = this.getTaskId();
        if (!start && StringUtils.isEmpty((CharSequence)taskId)) {
            this.dispatchTasks();
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            this.updateProgress(taskInfo, evt);
            if (taskInfo.isTaskEnd()) {
                this.setComplete();
                if (taskInfo.isFailure()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u53cd\u7ed3\u7b97\u5f02\u6b65\u6267\u884c\u5931\u8d25\uff1a{0}", (String)"SettleProgressFormPlugin_9", (String)"scmc-ism-form", (Object[])new Object[]{taskInfo.getFailureReason()}));
                }
            }
        }
    }

    private String dispatchTasks() {
        String traceId;
        String billInfo = (String)this.getView().getFormShowParameter().getCustomParam("billInfo");
        Object opType = this.getView().getFormShowParameter().getCustomParam("optype");
        String taskId = null;
        if (billInfo != null && opType != null) {
            traceId = (String)this.getView().getFormShowParameter().getCustomParam("traceid");
            if ("settle".equals(opType)) {
                taskId = this.settleTaskDispatch((Map)SerializationUtils.fromJsonString((String)billInfo, Map.class), traceId);
            } else if ("unsettle".equals(opType)) {
                taskId = this.unSettleTaskDisPatch((List)SerializationUtils.fromJsonString((String)billInfo, List.class), traceId);
            }
        }
        traceId = (String)this.getView().getFormShowParameter().getCustomParam("traceid");
        this.getView().getPageCache().put(traceId, taskId);
        TaskHelper.putAppCache(taskId);
        return taskId;
    }

    private String settleTaskDispatch(Map<String, List<Long>> billInfo, String traceId) {
        ArrayList<String> taskIds = new ArrayList<String>();
        BizBatchProcessor<Long, String> processor = new BizBatchProcessor<Long, String>(new SettleBizAsyncExecutor("ism"));
        taskIds.addAll(processor.settleExec(billInfo, traceId));
        return (String)taskIds.get(0);
    }

    private String unSettleTaskDisPatch(List<Long> billIds, String traceId) {
        ArrayList<String> taskIds = new ArrayList<String>();
        if (!billIds.isEmpty()) {
            BizBatchProcessor<Long, String> unProcessor = new BizBatchProcessor<Long, String>(new UnSettleBizAsyncExecutor());
            taskIds.addAll(unProcessor.unSettleExec(billIds, traceId));
        }
        return (String)taskIds.get(0);
    }

    private void setComplete() {
        this.stopBar();
        int fail = (Integer)this.getModel().getValue("fail");
        if (fail > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btnok"});
        }
        TaskHelper.removeAppCache(this.getTaskId());
    }

    private void updateProgress(TaskInfo taskInfo, ProgressEvent evt) {
        String taskData = taskInfo.getData();
        this.setPageFieldValue(taskData);
        int progress = taskInfo.getProgress();
        if (evt != null) {
            evt.setProgress(progress);
        }
    }

    private void setPageFieldValue(String taskData) {
        int complete = 0;
        int fail = 0;
        if (StringUtils.isNotEmpty((CharSequence)taskData)) {
            Map custData = (Map)SerializationUtils.fromJsonString((String)taskData, Map.class);
            int success = custData.containsKey("success") ? (Integer)custData.get("success") : 0;
            fail = custData.containsKey("failcount") ? (Integer)custData.get("failcount") : 0;
            complete = success + fail;
        }
        if (complete != fail) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"successpanel"});
        }
        if (fail > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"failpanel"});
        }
        this.getModel().setValue("complete", (Object)complete);
        this.getModel().setValue("fail", (Object)fail);
        this.getModel().setValue("success", (Object)(complete - fail));
    }

    private String getTaskId() {
        String traceId = (String)this.getView().getFormShowParameter().getCustomParam("traceid");
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            taskId = this.getView().getPageCache().get(traceId);
        }
        return taskId;
    }

    private void startBar() {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbar");
        progressBar.start();
    }

    private void stopBar() {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbar");
        progressBar.stop();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String canClose = this.getView().getPageCache().get("canclose");
        if (Boolean.parseBoolean(canClose)) {
            return;
        }
        String taskId = this.getTaskId();
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (StringUtils.isEmpty((CharSequence)taskId) || !taskInfo.isTaskEnd()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u8fd8\u672a\u6267\u884c\u5b8c\u6210\uff0c\u5173\u95ed\u8fdb\u5ea6\u6761\u540e\uff0c\u64cd\u4f5c\u4f1a\u8f6c\u5165\u540e\u53f0\u6267\u884c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SettleProgressFormPlugin_5", (String)"scmc-ism-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("close_confirm", (IFormPlugin)this));
            this.stopBar();
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("close_confirm".equals(evt.getCallBackId())) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.getView().getPageCache().put("canclose", "true");
                this.toBackground();
                this.getView().close();
            } else if (evt.getResult() == MessageBoxResult.Cancel) {
                this.startBar();
            }
        }
    }

    private boolean isStart() {
        String start = this.getPageCache().get("isstart");
        if (StringUtils.isBlank((CharSequence)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put("isstart", String.valueOf(start));
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String opKey = control.getKey();
        if ("btnok".equals(opKey)) {
            Map<String, Object> failInfo = this.querySettleInfo();
            if (failInfo.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e\uff0c\u65e5\u5fd7\u53ef\u80fd\u5df2\u88ab\u6e05\u9664\u3002", (String)"SettleProgressFormPlugin_6", (String)"scmc-ism-form", (Object[])new Object[0]));
            } else {
                Object opType = this.getView().getFormShowParameter().getCustomParam("optype");
                StringBuilder caption = new StringBuilder();
                if ("unsettle".equals(opType)) {
                    caption.append(ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u6267\u884c\u5931\u8d25\u4fe1\u606f", (String)"SettleProgressFormPlugin_10", (String)"scmc-ism-form", (Object[])new Object[0]));
                }
                PageShowHelper.showOperResult(this.getView(), failInfo, caption.toString());
            }
        }
    }

    private Map<String, Object> querySettleInfo() {
        DynamicObject[] dynamicObjectCollection;
        String billno = (String)this.getView().getFormShowParameter().getCustomParam("billno");
        Map billIdToNo = StringUtils.isNotEmpty((CharSequence)billno) ? (Map)SerializationUtils.fromJsonString((String)billno, Map.class) : new HashMap(16);
        HashMap<String, Object> failInfo = new HashMap<String, Object>(16);
        String traceId = (String)this.getView().getFormShowParameter().getCustomParam("traceid");
        for (DynamicObject dynamicObject : dynamicObjectCollection = BusinessDataServiceHelper.load((String)"ism_settle_fail_log", (String)"billid,failreason_tag", (QFilter[])new QFilter("traceid", "=", (Object)traceId).toArray())) {
            String curBillId = dynamicObject.getString("billid");
            String failMsg = dynamicObject.getString("failreason_tag");
            String billNo = (String)billIdToNo.get(curBillId);
            if (!StringUtils.isNotEmpty((CharSequence)billNo)) continue;
            failInfo.put(billNo, failMsg);
        }
        return failInfo;
    }

    private void toBackground() {
        String taskId = this.getTaskId();
        String opType = (String)this.getView().getFormShowParameter().getCustomParam("optype");
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            taskId = this.dispatchTasks();
        }
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u53d1\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SettleProgressFormPlugin_4", (String)"scmc-ism-form", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)opType)) {
            if (TaskClientProxy.isExistTask((String)taskId)) {
                return;
            }
            JobInfo jobInfo = "settle".equals(opType) ? JobHelper.buildJobInfo(UUID.randomUUID().toString(), InnerSettleExecuteTask.class.getName(), ResManager.loadKDString((String)"\u7ec4\u7ec7\u95f4\u7ed3\u7b97", (String)"SettleProgressFormPlugin_7", (String)"scmc-ism-form", (Object[])new Object[0]), new HashMap<String, Object>(2)) : JobHelper.buildJobInfo(UUID.randomUUID().toString(), InnerUnSettleExecuteTask.class.getName(), ResManager.loadKDString((String)"\u7ec4\u7ec7\u95f4\u53cd\u7ed3\u7b97", (String)"SettleProgressFormPlugin_8", (String)"scmc-ism-form", (Object[])new Object[0]), new HashMap<String, Object>(2));
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
            jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
            jobFormInfo.setCanBackground(true);
            jobFormInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
            jobFormInfo.setClickClassName(TaskClick.class.getName());
            CloseCallBack closeCallBack = new CloseCallBack(TaskFinishCallBack.class.getName(), "taskfinishcallback");
            jobFormInfo.setCloseCallBack(closeCallBack);
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)("settleprogress-background-monitor" + taskId), (Runnable)subscriber);
        }
    }
}

