/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.business.helper.InputConstsHelper;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.business.helper.filter.CommonFilterHelper;
import kd.scmc.ism.common.model.args.InputConstsResult;
import kd.scmc.ism.common.selectstrategy.BaseDataTypeStrategy;
import kd.scmc.ism.common.selectstrategy.ExcludeBaseDataStrategy;
import kd.scmc.ism.formplugin.template.AbstractISMBaseFormPlugin;
import kd.scmc.ism.lang.ModelLang;
import org.apache.commons.lang.StringUtils;

public class BaseMatchConditonEdit
extends AbstractISMBaseFormPlugin {
    private static final String MATCH_CONDTION_DIM_CB = "matchConditionDimCB";
    private static final String G_MATCH_CONDTION_DIM_CB = "gmatchConditionDimCB";
    private static final String G_MATCH_CONDTION_VALUE_CB = "gmatchConditionValueCB";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"conditondimtext", "conditionvalue", "gconditondimtext", "gconditionvalue"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "conditondimtext": {
                this.dimChange(e);
                break;
            }
            case "conditionvalue": {
                this.valueChange(e);
                break;
            }
            case "gconditondimtext": {
                this.groupDimChange(e);
                break;
            }
            case "gconditionvalue": {
                this.groupValueChange(e);
                break;
            }
            case "comparison": {
                this.comparisonChange(e);
                break;
            }
        }
    }

    private void comparisonChange(PropertyChangedArgs e) {
        ChangeData cdata = e.getChangeSet()[0];
        String comparison = (String)cdata.getNewValue();
        boolean isNullComparision = this.isNullComparision(comparison);
        if (isNullComparision) {
            this.getModel().setValue("conditionvalue", (Object)"-", cdata.getRowIndex());
        } else {
            this.getModel().setValue("conditionvalue", (Object)"", cdata.getRowIndex());
        }
        this.getView().setEnable(Boolean.valueOf(!isNullComparision), cdata.getRowIndex(), new String[]{"conditionvalue", "conditionvaluestr_tag"});
    }

    private boolean isNullComparision(String comparison) {
        return "is null".equals(comparison) || "is not null".equals(comparison) || "not null".equals(comparison);
    }

    private void dimChange(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        for (ChangeData cdata : e.getChangeSet()) {
            if (this.isNullComparision((String)model.getValue("comparison"))) {
                model.setValue("conditiondimkey", (Object)"", cdata.getRowIndex());
                model.setValue("conditionvalue", (Object)"-", cdata.getRowIndex());
                this.getView().setEnable(Boolean.FALSE, cdata.getRowIndex(), new String[]{"conditionvalue", "conditionvaluestr_tag"});
                continue;
            }
            model.setValue("conditiondimkey", (Object)"", cdata.getRowIndex());
            model.setValue("conditionvalue", (Object)"", cdata.getRowIndex());
            this.getView().setEnable(Boolean.TRUE, cdata.getRowIndex(), new String[]{"conditionvalue", "conditionvaluestr_tag"});
        }
    }

    private void valueChange(PropertyChangedArgs e) {
        for (ChangeData cdata : e.getChangeSet()) {
            this.getModel().setValue("conditionvaluestr", (Object)"", cdata.getRowIndex());
            this.getModel().setValue("conditionvaluestr_tag", (Object)"", cdata.getRowIndex());
        }
    }

    private void groupDimChange(PropertyChangedArgs e) {
        for (ChangeData cdata : e.getChangeSet()) {
            this.getModel().setValue("gconditiondimkey", (Object)"", cdata.getRowIndex());
            this.getModel().setValue("gconditionvalue", (Object)"", cdata.getRowIndex());
            this.getModel().setValue("grouprelation", null, cdata.getRowIndex());
        }
    }

    private void groupValueChange(PropertyChangedArgs e) {
        for (ChangeData cdata : e.getChangeSet()) {
            this.getModel().setValue("gconditionvaluestr", (Object)"", cdata.getRowIndex());
            this.getModel().setValue("gconditionvaluestr_tag", (Object)"", cdata.getRowIndex());
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "conditondimtext": {
                this.clickConditionDimText();
                break;
            }
            case "conditionvalue": {
                this.clickConditionValue();
                break;
            }
            case "gconditondimtext": {
                this.clickGroupConditionDimText();
                break;
            }
            case "gconditionvalue": {
                this.clickGroupConditionValue();
                break;
            }
        }
    }

    private void clickConditionDimText() {
        String pagename = ModelLang.plsSelectConditionDim();
        ArrayList<String> names = new ArrayList<String>(0);
        PageShowHelper.showSelectColsPage(this.getView(), "ism_billmapcfg", ExcludeBaseDataStrategy.build(names), pagename, new CloseCallBack((IFormPlugin)this, MATCH_CONDTION_DIM_CB));
    }

    private void clickConditionValue() {
        int index;
        IDataModel model = this.getModel();
        String dimKey = (String)model.getValue("conditiondimkey", index = model.getEntryCurrentRowIndex("matchconditions"));
        if (StringUtils.isEmpty((String)dimKey)) {
            String message = ModelLang.conditonDimIsEmpty();
            this.getView().showTipNotification(message);
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ism_billmapcfg");
        IDataEntityProperty prop = entityType.findProperty(dimKey);
        String srcValue = (String)model.getValue("conditionvaluestr_tag", index);
        InputConstsHelper.showInputMultiConsts((IFormPlugin)this, this.getView(), prop, "", srcValue);
    }

    private void clickGroupConditionDimText() {
        String pagename = ModelLang.plsSelectConditionDim();
        Map objs = BusinessDataServiceHelper.loadFromCache((String)"msmod_datagrouprelation", (String)"dataobj", (QFilter[])CommonFilterHelper.getAllFilters());
        HashSet<String> dataEntities = new HashSet<String>(objs.size());
        for (DynamicObject obj : objs.values()) {
            DynamicObject dataObj = obj.getDynamicObject("dataobj");
            dataEntities.add(dataObj.getString("number"));
        }
        PageShowHelper.showSelectColsPage(this.getView(), "ism_billmapcfg", new BaseDataTypeStrategy(dataEntities), pagename, new CloseCallBack((IFormPlugin)this, G_MATCH_CONDTION_DIM_CB));
    }

    private void clickGroupConditionValue() {
        int index;
        IDataModel model = this.getModel();
        String dimKey = (String)model.getValue("gconditiondimkey", index = model.getEntryCurrentRowIndex("gmatchconditions"));
        if (StringUtils.isEmpty((String)dimKey)) {
            String message = ModelLang.conditonDimIsEmpty();
            this.getView().showTipNotification(message);
            return;
        }
        DynamicObject groupRelation = (DynamicObject)this.getValue("grouprelation", index);
        BasedataProp prop = new BasedataProp();
        prop.setBaseEntityId(groupRelation.getDynamicObject("groupobj").getString("number"));
        String srcValue = (String)model.getValue("gconditionvaluestr_tag", index);
        InputConstsHelper.showInputMultiConsts((IFormPlugin)this, this.getView(), (IDataEntityProperty)prop, G_MATCH_CONDTION_VALUE_CB, srcValue);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        this.getModel().beginInit();
        InputConstsResult result = InputConstsHelper.getInputConstsResult(e);
        if (result != null) {
            this.selectF7CloseCallBack(result);
        } else if (e.getActionId().equals(MATCH_CONDTION_DIM_CB)) {
            this.matchCondtionDimCloseCallBack((String)e.getReturnData());
        } else if (e.getActionId().equals(G_MATCH_CONDTION_DIM_CB)) {
            this.matchGroupCondtionDimCloseCallBack((String)e.getReturnData());
        }
        this.getModel().endInit();
        this.getView().updateView("matchconditions");
        this.getView().updateView("gmatchconditions");
    }

    private void matchCondtionDimCloseCallBack(String selectField) {
        IDataModel model = this.getModel();
        if (StringUtils.isNotEmpty((String)selectField)) {
            JSONArray array = JSON.parseArray((String)selectField);
            if (array.isEmpty()) {
                return;
            }
            JSONObject jsonObject = array.getJSONObject(0);
            int index = model.getEntryCurrentRowIndex("matchconditions");
            model.setValue("conditiondimkey", (Object)jsonObject.getString("id"), index);
            model.setValue("conditondimtext", (Object)jsonObject.getString("text"), index);
            if (this.isNullComparision((String)model.getValue("comparison"))) {
                model.setValue("conditionvalue", (Object)"-", index);
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"conditionvalue", "conditionvaluestr_tag"});
            } else {
                model.setValue("conditionvalue", null, index);
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"conditionvalue", "conditionvaluestr_tag"});
            }
            model.setValue("conditionvaluestr_tag", null, index);
        }
    }

    private void matchGroupCondtionDimCloseCallBack(String selectField) {
        IDataModel model = this.getModel();
        if (StringUtils.isNotEmpty((String)selectField)) {
            JSONArray array = JSON.parseArray((String)selectField);
            if (array.isEmpty()) {
                return;
            }
            JSONObject jsonObject = array.getJSONObject(0);
            int index = model.getEntryCurrentRowIndex("gmatchconditions");
            model.setValue("gconditiondimkey", (Object)jsonObject.getString("id"), index);
            model.setValue("gconditondimtext", (Object)jsonObject.getString("text"), index);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ism_billmapcfg");
            BasedataProp prop = (BasedataProp)entityType.findProperty(jsonObject.getString("id"));
            DynamicObject groupRelation = BusinessDataServiceHelper.loadSingleFromCache((String)"msmod_datagrouprelation", (QFilter[])new QFilter("dataobj", "=", (Object)prop.getBaseEntityId()).toArray());
            model.setValue("grouprelation", (Object)groupRelation, index);
            model.setValue("gconditionvalue", null, index);
            model.setValue("gconditionvaluestr_tag", null, index);
        }
    }

    private void selectF7CloseCallBack(InputConstsResult result) {
        IDataModel model = this.getModel();
        if (G_MATCH_CONDTION_VALUE_CB.equals(result.getCloseCallBackId())) {
            int index = model.getEntryCurrentRowIndex("gmatchconditions");
            model.setValue("gconditionvalue", (Object)result.getConstsDes(), index);
            model.setValue("gconditionvaluestr_tag", (Object)result.getConsts(), index);
        } else {
            int index = model.getEntryCurrentRowIndex("matchconditions");
            model.setValue("conditionvalue", (Object)result.getConstsDes(), index);
            model.setValue("conditionvaluestr_tag", (Object)result.getConsts(), index);
        }
    }
}

