/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.batexec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.scmc.ism.model.batexec.handle.IBizExecutor;

public class BizBatchProcessor<T, R> {
    private final int batchSize;
    private List<T> elements = new ArrayList<T>(128);
    private List<R> results = new ArrayList<R>(16);
    private final IBizExecutor<T, R> exeuctor;

    public BizBatchProcessor(IBizExecutor<T, R> exeuctor, int batchSize) {
        if (exeuctor == null) {
            // empty if block
        }
        this.exeuctor = exeuctor;
        if (batchSize <= 0) {
            // empty if block
        }
        this.batchSize = batchSize;
    }

    public BizBatchProcessor(IBizExecutor<T, R> exeuctor) {
        this(exeuctor, 100);
    }

    public void addAllAndExec(Collection<T> element) {
        for (T t : element) {
            this.addAndExec(t);
        }
    }

    public void addAndExec(T element) {
        this.elements.add(element);
        if (this.elements.size() >= this.batchSize) {
            this.results.add(this.exeuctor.execute(this.elements));
            this.elements = new ArrayList<T>(this.batchSize);
        }
    }

    public List<R> doProcess() {
        if (!this.elements.isEmpty()) {
            this.results.add(this.exeuctor.execute(this.elements));
        }
        ArrayList<R> retResult = new ArrayList<R>(this.results);
        this.results.clear();
        return retResult;
    }

    public List<R> settleExec(Map<R, List<T>> billInfo, String traceId) {
        R r;
        if (!billInfo.isEmpty() && (r = this.exeuctor.execute(billInfo, traceId)) != null) {
            this.results.add(r);
        }
        ArrayList<R> retResult = new ArrayList<R>(this.results);
        this.results.clear();
        return retResult;
    }

    public List<R> unSettleExec(List<T> billId, String traceId) {
        R r;
        if (!billId.isEmpty() && (r = this.exeuctor.execute(billId, traceId)) != null) {
            this.results.add(r);
        }
        ArrayList<R> retResult = new ArrayList<R>(this.results);
        this.results.clear();
        return retResult;
    }
}

