/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.bill.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.scmc.ism.model.bill.impl.AbstractSettleBillModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;
import kd.scmc.ism.model.mapcfg.fieldinfo.BillFieldInfo;

public class SettleBillEntryModel
extends AbstractSettleBillModel {
    private final SettleBillModel billModel;

    SettleBillEntryModel(SettleBillModel billModel, DynamicObject entryObj, SettleBillMapCfg mapCfg) {
        super(entryObj, mapCfg);
        this.billModel = billModel;
    }

    @Override
    public Object getValue(String key) {
        int loc = this.getMapCfg().getFieldLoc(this.getBillEntityType(), key);
        if (1 == loc) {
            return this.billModel.getCurValue(key);
        }
        if (2 == loc) {
            return this.getCurValue(key);
        }
        return this.getDefaultValue(key);
    }

    @Override
    public Object getValueFromSrcObj(String key) {
        BillFieldInfo billFieldInfo = this.getMapCfg().getSrcFieldInfo(this.getBillEntityType(), key);
        if (billFieldInfo == null) {
            return null;
        }
        if (billFieldInfo.isBillHead()) {
            return this.billModel.getCurValueFromSrcObj(billFieldInfo.getBillFieldKey());
        }
        if (billFieldInfo.isBillEntry()) {
            return this.getCurValueFromSrcObj(billFieldInfo.getBillFieldKey());
        }
        return null;
    }

    @Override
    public void setValue(String key, Object value) {
        int loc = this.getMapCfg().getFieldLoc(this.getBillEntityType(), key);
        if (1 == loc) {
            this.billModel.putCurValue(key, value);
        } else if (2 == loc) {
            this.putCurValue(key, value);
        }
    }

    public ListSelectedRow toRow() {
        ListSelectedRow row = new ListSelectedRow((Object)this.billModel.getId(), Boolean.TRUE);
        row.setFormID(this.billModel.getBillEntityType());
        row.setEntryPrimaryKeyValue((Object)this.getId());
        row.setEntryEntityKey(this.getObj().getDataEntityType().getName());
        return row;
    }

    public SettleBillModel getBillModel() {
        return this.billModel;
    }

    @Override
    public String getBillEntityType() {
        return this.billModel.getBillEntityType();
    }
}

