/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.bill.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.scmc.ism.common.model.assist.OrgAssistant;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.AbstractSettleBillModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;
import kd.scmc.ism.model.mapcfg.fieldinfo.BillFieldInfo;
import org.apache.commons.lang.StringUtils;

public class SettleBillModel
extends AbstractSettleBillModel {
    private List<SettleBillEntryModel> entryModels = null;
    private Map<Long, SettleBillEntryModel> entryModelMap = null;
    private String billEntityType;
    private DynamicObject mainBizOrg = null;
    private String entryKeyField;
    private long exRateTableId = 0L;
    private long baseCurrencyId = 0L;

    public static SettleBillModel build(DynamicObject billObj, SettleBillMapCfg mapCfg) {
        SettleBillModel billModel = new SettleBillModel(billObj, mapCfg);
        billModel.init();
        return billModel;
    }

    protected SettleBillModel(DynamicObject billObj, SettleBillMapCfg mapCfg) {
        super(billObj, mapCfg);
    }

    private void init() {
        String entryKeyField;
        MainEntityType dataEntityType = (MainEntityType)this.getObj().getDataEntityType();
        this.billEntityType = dataEntityType.getName();
        String mainOrg = dataEntityType.getMainOrg();
        this.mainBizOrg = !StringUtils.isEmpty((String)mainOrg) ? this.getObj().getDynamicObject(dataEntityType.getMainOrg()) : (DynamicObject)this.getValue("mainbizorg");
        this.entryKeyField = entryKeyField = this.getMapCfg().getFieldKey(this.billEntityType, "billentry");
        DynamicObjectCollection entries = this.getObj().getDynamicObjectCollection(entryKeyField);
        this.entryModels = new ArrayList<SettleBillEntryModel>(entries.size());
        this.entryModelMap = new HashMap<Long, SettleBillEntryModel>(entries.size());
        for (DynamicObject entry : entries) {
            SettleBillEntryModel billEntryModel = new SettleBillEntryModel(this, entry, this.getMapCfg());
            this.entryModels.add(billEntryModel);
            this.entryModelMap.put(DynamicObjectUtil.getPkValue(entry), billEntryModel);
        }
    }

    public void initExrateTable(OrgAssistant orgAssistant) {
        if (this.mainBizOrg == null) {
            return;
        }
        Long mainBizOrgId = DynamicObjectUtil.getPkValue(this.mainBizOrg);
        DynamicObject baseCurrency = (DynamicObject)this.getValue("basecurrency");
        DynamicObject exrateTable = (DynamicObject)this.getValue("exratetable");
        this.baseCurrencyId = baseCurrency == null ? orgAssistant.getOrgCurrency(mainBizOrgId) : DynamicObjectUtil.getPkValue(baseCurrency).longValue();
        this.exRateTableId = exrateTable == null ? orgAssistant.getOrgExrateTable(mainBizOrgId) : DynamicObjectUtil.getPkValue(exrateTable).longValue();
    }

    @Override
    public Object getValue(String key) {
        Iterator<Object> values = this.getValues(key).iterator();
        if (values.hasNext()) {
            return values.next();
        }
        return null;
    }

    public Set<Object> getValues(String key) {
        HashSet<Object> values = new HashSet<Object>(0);
        int loc = this.getMapCfg().getFieldLoc(this.getBillEntityType(), key);
        if (1 == loc) {
            values.add(this.getCurValue(key));
        } else if (2 == loc) {
            for (SettleBillEntryModel entryModel : this.entryModels) {
                values.add(entryModel.getCurValue(key));
            }
        } else {
            Object defaultValue = this.getDefaultValue(key);
            if (defaultValue != null) {
                values.add(this.getDefaultValue(key));
            }
        }
        return values;
    }

    @Override
    public Object getValueFromSrcObj(String key) {
        return this.getValueFromSrcObj(key, Object.class);
    }

    public <T> T getValueFromSrcObj(String key, Class<T> clazz) {
        Iterator<T> valuesFromSrcObj = this.getValuesFromSrcObj(key, clazz).iterator();
        if (valuesFromSrcObj.hasNext()) {
            return valuesFromSrcObj.next();
        }
        return null;
    }

    public Set<Object> getValuesFromSrcObj(String key) {
        return this.getValuesFromSrcObj(key, Object.class);
    }

    public <T> Set<T> getValuesFromSrcObj(String key, Class<T> clazz) {
        HashSet<Object> values = new HashSet<Object>(0);
        BillFieldInfo billFieldInfo = this.getMapCfg().getSrcFieldInfo(this.getBillEntityType(), key);
        if (billFieldInfo == null) {
            return new HashSet(0);
        }
        String billFieldKey = billFieldInfo.getBillFieldKey();
        if (billFieldInfo.isBillHead()) {
            values.add(this.getCurValueFromSrcObj(billFieldKey));
        } else if (billFieldInfo.isBillEntry()) {
            for (SettleBillEntryModel entryModel : this.entryModels) {
                values.add(entryModel.getCurValueFromSrcObj(billFieldKey));
            }
        }
        return values;
    }

    @Override
    public void setValue(String key, Object value) {
        int loc = this.getMapCfg().getFieldLoc(this.getBillEntityType(), key);
        if (1 == loc) {
            this.putCurValue(key, value);
        } else if (2 == loc) {
            for (SettleBillEntryModel entryModel : this.entryModels) {
                entryModel.putCurValue(key, value);
            }
        }
    }

    public void setValueToObj(String key, Object value) {
        BillFieldInfo fieldInfo = this.getMapCfg().getSrcFieldInfo(this.getBillEntityType(), key);
        if (fieldInfo == null) {
            return;
        }
        String billField = fieldInfo.getBillFieldKey();
        int loc = fieldInfo.getKeyloc();
        if (1 == loc) {
            this.getObj().set(billField, value);
        } else if (2 == loc) {
            for (SettleBillEntryModel entryModel : this.entryModels) {
                entryModel.getObj().set(billField, value);
            }
        }
    }

    public void writeToBill() {
        this.valueWriteBack();
        for (SettleBillEntryModel billEntryModel : this.entryModels) {
            billEntryModel.valueWriteBack();
        }
    }

    public DynamicObject getMainBizOrg() {
        return this.mainBizOrg;
    }

    @Override
    public String getBillEntityType() {
        return this.billEntityType;
    }

    public List<SettleBillEntryModel> getEntries() {
        return this.entryModels;
    }

    public SettleBillEntryModel getEntryModel(long entryId) {
        return this.entryModelMap.get(entryId);
    }

    public long getExRateTableId() {
        return this.exRateTableId;
    }

    public long getBaseCurrencyId() {
        return this.baseCurrencyId;
    }

    public String getEntryKeyField() {
        return this.entryKeyField;
    }
}

