/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.scmc.ism.business.helper.InterOrgBizHelper;
import kd.scmc.ism.common.errocode.ISMErrorCode;
import kd.scmc.ism.common.model.entity.BillExecSequence;
import kd.scmc.ism.common.model.log.SettleLogHandler;
import kd.scmc.ism.common.utils.CommonUtils;

public abstract class AbstractBizOperSplitter {
    private Map<Long, List<ErrorCode>> failIdAndReason = new HashMap<Long, List<ErrorCode>>(64);
    private Map<Long, SettleLogHandler> logHandlers = new HashMap<Long, SettleLogHandler>(16);
    private Map<Long, DynamicObject> billInfos = new HashMap<Long, DynamicObject>(16);

    protected void initInfoFromLogObjs(DynamicObject[] settleLogInfos) {
        for (DynamicObject settleLogObj : settleLogInfos) {
            this.addSettleLog(settleLogObj);
        }
        Map<Long, SettleLogHandler> logHandlers = this.getLogHandlers();
        ArrayList<BillExecSequence> allSequences = new ArrayList<BillExecSequence>(logHandlers.size());
        for (SettleLogHandler logHandler : logHandlers.values()) {
            allSequences.add(logHandler.getSequence());
        }
        this.billInfos = InterOrgBizHelper.getBillInfosByBillExecSeq(allSequences);
    }

    protected void addFailIdAndReason(Long billId, String reason) {
        CommonUtils.mapGetListValue(this.failIdAndReason, billId).add(ISMErrorCode.commonCode(reason));
    }

    protected void addFailIdAndReason(Long billId, ErrorCode erroCode) {
        CommonUtils.mapGetListValue(this.failIdAndReason, billId).add(erroCode);
    }

    public Map<Long, List<ErrorCode>> getFailIdAndReason() {
        return this.failIdAndReason;
    }

    protected void addSettleLog(DynamicObject settleLogObj) {
        long sourceId = settleLogObj.getLong("sourceid");
        this.logHandlers.put(sourceId, SettleLogHandler.load(settleLogObj));
    }

    protected void addBillInfos(Map<Long, DynamicObject> billInfos) {
        this.billInfos.putAll(billInfos);
    }

    public Map<Long, SettleLogHandler> getLogHandlers() {
        return this.logHandlers;
    }

    public Map<Long, DynamicObject> getBillInfos() {
        return this.billInfos;
    }
}

