/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.util.ExceptionUtils;
import kd.scmc.ism.business.utils.BizLockUtils;
import kd.scmc.ism.common.errocode.ISMErrorCode;
import kd.scmc.ism.lang.ModelLang;

public class BizLocker
implements AutoCloseable {
    private final String oper;
    private final Collection<Long> needLockIds;
    private Set<Long> lockedIds = new HashSet<Long>(16);
    private Map<Long, ErrorCode> lockFailedInfos = new HashMap<Long, ErrorCode>();

    public BizLocker(Collection<Long> needLockIds, String oper) {
        this.needLockIds = needLockIds;
        this.oper = oper;
    }

    public static BizLocker create(Collection<Long> needLockIds, String oper) {
        return BizLocker.create(needLockIds, oper, false);
    }

    public static BizLocker create(Collection<Long> needLockIds, String oper, boolean isStrict) {
        BizLocker locker = new BizLocker(needLockIds, oper);
        if (isStrict) {
            locker.doAllLock();
        } else {
            locker.doLock();
        }
        return locker;
    }

    private void doAllLock() {
        Set<Long> faillockIds = BizLockUtils.doAllLock(this.needLockIds, this.oper);
        if (!faillockIds.isEmpty()) {
            throw new KDBizException(ModelLang.billBizLocked());
        }
        this.lockedIds.addAll(this.needLockIds);
    }

    private void doLock() {
        try {
            Set<Long> faillockIds = BizLockUtils.doLock(this.needLockIds, this.oper);
            for (Long needLockId : this.needLockIds) {
                if (faillockIds.contains(needLockId)) {
                    this.lockFailedInfos.put(needLockId, ISMErrorCode.lockFail());
                    continue;
                }
                this.lockedIds.add(needLockId);
            }
        }
        catch (Exception e) {
            String erroInfo = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            for (Long needLockId : this.needLockIds) {
                this.lockFailedInfos.put(needLockId, ISMErrorCode.lockFailWithInfo(erroInfo));
            }
        }
    }

    public Set<Long> getLockedIds() {
        return this.lockedIds;
    }

    public Map<Long, ErrorCode> getLockFailedInfos() {
        return this.lockFailedInfos;
    }

    @Override
    public void close() {
        this.doRelease();
    }

    public void doRelease() {
        BizLockUtils.releaseLock(this.lockedIds, this.oper);
    }
}

