/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.core.settle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.business.helper.SettleLogHelper;
import kd.scmc.ism.common.model.log.SettleLogHandler;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.model.core.AbstractBizOperSplitter;

public class SettleOperSplitter
extends AbstractBizOperSplitter {
    private String billType = null;
    private List<Long> executeIds = new ArrayList<Long>(16);
    private List<Long> redoIds = new ArrayList<Long>(16);

    private SettleOperSplitter() {
    }

    public static SettleOperSplitter doParse(Collection<Long> billIds, String billtype) {
        DynamicObject[] settleLogInfos = SettleLogHelper.getLogInfoBySrcIds(billIds);
        if (settleLogInfos == null || settleLogInfos.length == 0) {
            return SettleOperSplitter.buildExecute(billIds, billtype);
        }
        return SettleOperSplitter.buildFromSettleLog(billIds, billtype, settleLogInfos);
    }

    private static SettleOperSplitter buildExecute(Collection<Long> billIds, String billtype) {
        SettleOperSplitter operInfo = new SettleOperSplitter();
        operInfo.setBillType(billtype);
        operInfo.getExecuteIds().addAll(billIds);
        return operInfo;
    }

    private static SettleOperSplitter buildFromSettleLog(Collection<Long> billIds, String billtype, DynamicObject[] settleLogInfos) {
        SettleOperSplitter operInfo = new SettleOperSplitter();
        operInfo.setBillType(billtype);
        operInfo.initInfoFromLogObjs(settleLogInfos);
        operInfo.parseBillId(billIds);
        return operInfo;
    }

    private void parseBillId(Collection<Long> billIds) {
        for (Long billId : billIds) {
            SettleLogHandler settleLog = this.getLogHandlers().get(billId);
            if (settleLog == null) {
                this.executeIds.add(billId);
                continue;
            }
            List<Long> allExecBillIds = settleLog.getSequence().getAllExecBillIds();
            if (allExecBillIds.isEmpty()) {
                this.executeIds.add(billId);
                continue;
            }
            int notExistBillCount = 0;
            int aduitBillCount = 0;
            for (Long settleBillId : settleLog.getSequence().getAllExecBillIds()) {
                DynamicObject bill = this.getBillInfos().get(settleBillId);
                if (bill == null) {
                    ++notExistBillCount;
                    continue;
                }
                if (!"C".equals(bill.getString("billstatus"))) continue;
                ++aduitBillCount;
            }
            if (aduitBillCount == allExecBillIds.size()) {
                this.addFailIdAndReason(billId, ModelLang.alreadyGenerateSettleBill());
                continue;
            }
            if (notExistBillCount == 0) {
                this.redoIds.add(billId);
                continue;
            }
            if (notExistBillCount == allExecBillIds.size()) {
                this.executeIds.add(billId);
                continue;
            }
            this.addFailIdAndReason(billId, ModelLang.alreadyGeneratePartSettleBill());
        }
    }

    private void setBillType(String billType) {
        this.billType = billType;
    }

    public List<Long> getExecuteIds() {
        return this.executeIds;
    }

    public List<Long> getRedoIds() {
        return this.redoIds;
    }

    public String getBillType() {
        return this.billType;
    }
}

