/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.core.settle.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.business.action.SettleActionFactory;
import kd.scmc.ism.business.action.SettleActionProcessor;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.log.SettleLogHandler;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.bill.impl.SimpleBillProxyModel;
import kd.scmc.ism.model.core.settle.ISettleOper;
import kd.scmc.ism.model.core.settle.SettleOperSplitter;

public class SettleOperRedo
implements ISettleOper {
    @Override
    public SettleOperResult doSettleOper(SettleOperSplitter splitter) {
        List<Long> redoIds = splitter.getRedoIds();
        if (redoIds.isEmpty()) {
            return new SettleOperResult();
        }
        ISMRequestContext reqContext = this.buidlRedoReqContext(splitter);
        SettleActionProcessor processor = SettleActionProcessor.build(this.getActions(), null);
        processor.doProcess(reqContext);
        return reqContext.getOperResult();
    }

    private ISMRequestContext buidlRedoReqContext(SettleOperSplitter splitter) {
        List<Long> redoIds = splitter.getRedoIds();
        Map<Long, SettleLogHandler> handlers = splitter.getLogHandlers();
        Map<Long, DynamicObject> billInfos = splitter.getBillInfos();
        HashMap<Long, SettleLogHandler> reqLogHandlers = new HashMap<Long, SettleLogHandler>(handlers.size());
        HashMap<Long, SettleBillModel> reqSettleBillModels = new HashMap<Long, SettleBillModel>(billInfos.size());
        for (Long redoId : redoIds) {
            SettleLogHandler logHandler = handlers.get(redoId);
            reqLogHandlers.put(redoId, logHandler);
            List<Long> execSequence = logHandler.getSequence().getAllExecBillIds();
            for (Long settleBillID : execSequence) {
                DynamicObject billObj = billInfos.get(settleBillID);
                reqSettleBillModels.put(settleBillID, SimpleBillProxyModel.build(billObj));
            }
        }
        ISMRequestContext reqContext = ISMRequestContext.createRedo(splitter.getBillType(), splitter.getRedoIds(), reqLogHandlers, reqSettleBillModels);
        return reqContext;
    }

    private List<AbstractSettleAction> getActions() {
        return SettleActionFactory.buildRedoActions();
    }
}

