/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.flow.sequence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.common.result.BatchOpExecuteResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.model.flow.ExecuteSequence;
import kd.scmc.ism.model.flow.sequence.AbstractSequenceExecutor;
import kd.scmc.ism.model.flow.sequence.RandomSequenceBatchExecutor;

public class GenSequenceExecutor
extends AbstractSequenceExecutor {
    private Collection<List<Long>> genSequences;
    private RandomSequenceBatchExecutor batchExcutor = RandomSequenceBatchExecutor.getInstance();

    public GenSequenceExecutor(Collection<List<Long>> genSequences) {
        this.genSequences = genSequences;
    }

    @Override
    public BatchOpExecuteResult execute(String op, Map<String, Map<Long, DynamicObject>> entityToBillMap) {
        if (CommonUtils.collectionIsEmpty(this.genSequences)) {
            return this.batchExcutor.execute(op, entityToBillMap);
        }
        HashMap<Long, DynamicObject> billInfos = new HashMap<Long, DynamicObject>(32);
        for (Map<Long, DynamicObject> billMap : entityToBillMap.values()) {
            billInfos.putAll(billMap);
        }
        return this.sequenceExecute(op, billInfos);
    }

    private BatchOpExecuteResult sequenceExecute(String op, Map<Long, DynamicObject> billInfos) {
        BatchOpExecuteResult result = BatchOpExecuteResult.success(op);
        List<ExecuteSequence> objQueues = this.createObjectQueues(billInfos);
        int maxSize = 0;
        HashSet<Long> remainBillIds = new HashSet<Long>(billInfos.keySet());
        for (ExecuteSequence executeSequence : objQueues) {
            int size = executeSequence.size();
            if (size > maxSize) {
                maxSize = size;
            }
            remainBillIds.removeAll(executeSequence.getRemainIds());
        }
        if (!remainBillIds.isEmpty()) {
            HashMap<String, Map<Long, DynamicObject>> execBillInfos = new HashMap<String, Map<Long, DynamicObject>>(16);
            for (Long remainBillId : remainBillIds) {
                DynamicObject remainBillObj = billInfos.get(remainBillId);
                Long billId = DynamicObjectUtil.getPkValue(remainBillObj);
                String billEntityName = remainBillObj.getDataEntityType().getName();
                CommonUtils.mapGetMapValue(execBillInfos, billEntityName).put(billId, remainBillObj);
            }
            result.combine(this.batchExcutor.execute(op, execBillInfos));
        }
        for (int i = 0; i < maxSize; ++i) {
            HashMap<String, Map<Long, DynamicObject>> hashMap = new HashMap<String, Map<Long, DynamicObject>>(16);
            for (ExecuteSequence executeSequence : objQueues) {
                if (executeSequence.isEmpty()) continue;
                DynamicObject billObj = executeSequence.poll();
                Long billId = DynamicObjectUtil.getPkValue(billObj);
                String billEntityName = billObj.getDataEntityType().getName();
                CommonUtils.mapGetMapValue(hashMap, billEntityName).put(billId, billObj);
            }
            BatchOpExecuteResult execute = this.batchExcutor.execute(op, hashMap);
            Set<Long> keySet = execute.getFailedBillMessage().keySet();
            if (!keySet.isEmpty()) {
                for (ExecuteSequence executeSequence : objQueues) {
                    long lastPollId;
                    if (executeSequence.isEmpty() || !keySet.contains(lastPollId = executeSequence.getLastPollId())) continue;
                    Set<Long> remainIds = executeSequence.getRemainIds();
                    for (Long remainId : remainIds) {
                        result.addFailBillMessage(remainId, ModelLang.preBillExecuteFail());
                    }
                    executeSequence.clear();
                }
            }
            result.combine(execute);
        }
        return result;
    }

    private List<ExecuteSequence> createObjectQueues(Map<Long, DynamicObject> billInfos) {
        ArrayList<ExecuteSequence> objQueues = new ArrayList<ExecuteSequence>(16);
        for (List<Long> genSequence : this.genSequences) {
            ExecuteSequence objQueue = new ExecuteSequence();
            for (Long billId : genSequence) {
                DynamicObject billObj = billInfos.get(billId);
                if (billObj == null) continue;
                objQueue.add(billObj);
            }
            if (objQueue.isEmpty()) continue;
            objQueues.add(objQueue);
        }
        return objQueues;
    }
}

