/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.group.expr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.formula.FormulaEngine;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.group.DataGroupClassfier;
import kd.scmc.ism.model.group.expr.GroupMatchFactor;
import kd.scmc.ism.model.group.expr.IGroupMatchExpression;

public class GroupMatchCondtionExpression
implements IGroupMatchExpression {
    private Map<Long, GroupMatchFactor> factors = new HashMap<Long, GroupMatchFactor>(16);
    private String sourceExpr = null;

    public static GroupMatchCondtionExpression create(DynamicObjectCollection gmcEntries) {
        GroupMatchCondtionExpression expr = new GroupMatchCondtionExpression();
        expr.init(gmcEntries);
        return expr;
    }

    private GroupMatchCondtionExpression() {
    }

    private void init(DynamicObjectCollection gmcEntries) {
        StringBuilder exprBuilder = new StringBuilder();
        for (int i = 0; i < gmcEntries.size(); ++i) {
            DynamicObject mcEntry = (DynamicObject)gmcEntries.get(i);
            String left = mcEntry.getString("gleft");
            if (!StringUtils.isEmpty((String)left)) {
                exprBuilder.append(left);
            }
            long entryId = mcEntry.getLong("id");
            GroupMatchFactor factor = this.buildFactor(mcEntry);
            this.factors.put(entryId, factor);
            exprBuilder.append(entryId);
            String right = mcEntry.getString("gright");
            if (!StringUtils.isEmpty((String)right)) {
                exprBuilder.append(right);
            }
            if (i >= gmcEntries.size() - 1) continue;
            exprBuilder.append(" ");
            exprBuilder.append(mcEntry.getString("glogic"));
            exprBuilder.append(" ");
        }
        this.sourceExpr = exprBuilder.toString();
    }

    private GroupMatchFactor buildFactor(DynamicObject mcEntry) {
        String key = mcEntry.getString("gconditiondimkey");
        String cp = mcEntry.getString("gcomparison");
        String conditionValueStr = mcEntry.getString("gconditionvaluestr_tag");
        DynamicObject relationId = mcEntry.getDynamicObject("grouprelation");
        List list = SerializationUtils.fromJsonStringToList((String)conditionValueStr, Object.class);
        ArrayList<Long> groupIds = new ArrayList<Long>(list.size());
        for (Object groupId : list) {
            groupIds.add(Long.valueOf(String.valueOf(groupId)));
        }
        return new GroupMatchFactor(key, cp, groupIds, DynamicObjectUtil.getPkValue(relationId));
    }

    @Override
    public boolean isMatch(Map<String, Object> param, DataGroupClassfier classfier) {
        if (StringUtils.isEmpty((String)this.sourceExpr)) {
            return true;
        }
        if (classfier == null) {
            return false;
        }
        HashMap<Long, Boolean> factorResults = new HashMap<Long, Boolean>(16);
        for (Map.Entry<Long, GroupMatchFactor> entry : this.factors.entrySet()) {
            Long l = entry.getKey();
            boolean result = this.checkFactor(entry.getValue(), param, classfier);
            factorResults.put(l, result);
        }
        String exprs = this.sourceExpr;
        for (Map.Entry entry : factorResults.entrySet()) {
            exprs = exprs.replaceAll(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        boolean bl = (Boolean)FormulaEngine.execExcelFormula((String)exprs);
        return bl;
    }

    private boolean checkFactor(GroupMatchFactor factor, Map<String, Object> param, DataGroupClassfier classfier) {
        Long dataId = (Long)param.get(factor.getKey());
        if (classfier == null) {
            return false;
        }
        boolean isOnGroup = false;
        if (dataId != null) {
            for (Long groupId : factor.getGroupIds()) {
                if (!classfier.isDataOnGroup(dataId, groupId, factor.getRelationId())) continue;
                isOnGroup = true;
                break;
            }
        }
        if ("in".equals(factor.getCompare())) {
            return isOnGroup;
        }
        return !isOnGroup;
    }

    @Override
    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>(this.factors.size());
        for (GroupMatchFactor factor : this.factors.values()) {
            keys.add(factor.getKey());
        }
        return keys;
    }
}

