/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.group.expr;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.group.DataGroupClassfier;
import kd.scmc.ism.model.group.expr.GroupMatchFactor;
import kd.scmc.ism.model.group.expr.IGroupMatchExpression;

public class GroupMatchEntryExpression
implements IGroupMatchExpression {
    private List<GroupMatchFactor> factors = new ArrayList<GroupMatchFactor>(16);

    public List<GroupMatchFactor> getFactors() {
        return this.factors;
    }

    public void addFactor(String key, Long groupId, Long relationId) {
        this.getFactors().add(new GroupMatchFactor(key, groupId, relationId));
    }

    @Override
    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>(this.factors.size());
        for (GroupMatchFactor factor : this.factors) {
            keys.add(factor.getKey());
        }
        return keys;
    }

    @Override
    public boolean isMatch(Map<String, Object> param, DataGroupClassfier classfier) {
        List<GroupMatchFactor> factors = this.getFactors();
        if (factors.isEmpty()) {
            return true;
        }
        for (GroupMatchFactor factor : factors) {
            Long dataId = (Long)param.get(factor.getKey());
            if (CommonUtils.idIsNull(dataId) || classfier == null) {
                return false;
            }
            if (classfier.isDataOnGroup(dataId, factor.getGroupId(), factor.getRelationId())) continue;
            return false;
        }
        return true;
    }
}

