/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.group.rel.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.scmc.ism.business.helper.CtrlInfoChecker;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.group.rel.collect.IGroupDataCollector;

public abstract class AbstractDataCollector
implements IGroupDataCollector {
    private CtrlInfoChecker checker;
    private Set<String> modelDataFields = new HashSet<String>(16);
    private Map<String, Set<Long>> dataIdsMap = new HashMap<String, Set<Long>>();
    private Map<String, Set<Long>> groupIdsMap = new HashMap<String, Set<Long>>();

    @Override
    public boolean isContainGroup() {
        return !this.groupIdsMap.isEmpty();
    }

    protected void collectData(Collection<SettleBillModel> models) {
        if (this.modelDataFields.isEmpty()) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ism_billmapcfg");
        for (String field : this.modelDataFields) {
            BasedataProp property = (BasedataProp)entityType.findProperty(field);
            String baseEntityId = property.getBaseEntityId();
            for (SettleBillModel billModel : models) {
                Set<DynamicObject> srcObjs = billModel.getValuesFromSrcObj(field, DynamicObject.class);
                if (srcObjs.isEmpty()) continue;
                ArrayList<Long> dataObjIds = new ArrayList<Long>(srcObjs.size());
                for (DynamicObject srcObj : srcObjs) {
                    if (srcObj == null) continue;
                    dataObjIds.add(this.getBaseDataId(srcObj));
                }
                CommonUtils.mapGetSetValue(this.dataIdsMap, baseEntityId).addAll(dataObjIds);
            }
        }
    }

    protected Map<String, Set<Long>> getGroupIdsMap() {
        return this.groupIdsMap;
    }

    @Override
    public Set<Long> getDataIds(String entityType) {
        Set<Long> ids = this.dataIdsMap.get(entityType);
        return ids;
    }

    @Override
    public Set<Long> getGroupIds(String entityType) {
        Set<Long> ids = this.groupIdsMap.get(entityType);
        return ids;
    }

    protected void addModelField(String fields) {
        this.modelDataFields.add(fields);
    }

    public Set<String> getModelDataFields() {
        return this.modelDataFields;
    }

    protected long getBaseDataId(DynamicObject obj) {
        if (this.checker != null) {
            return this.checker.getMasterId(obj);
        }
        return DynamicObjectUtil.getPkValue(obj);
    }

    public void setChecker(CtrlInfoChecker checker) {
        this.checker = checker;
    }

    public CtrlInfoChecker getChecker() {
        return this.checker;
    }
}

