/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.group.rel.collect;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.business.helper.CtrlInfoChecker;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.group.rel.collect.AbstractDataCollector;
import kd.scmc.ism.model.mapcfg.ModelMatchCfg;
import kd.scmc.ism.model.mapcfg.fieldinfo.MatchFieldInfo;

public class DataGroupCollector
extends AbstractDataCollector {
    private Map<String, Set<String>> groupFields = new HashMap<String, Set<String>>(16);

    public static DataGroupCollector create(ModelMatchCfg modelMatchCfg, CtrlInfoChecker ctrlInfoChecker) {
        DataGroupCollector collector = new DataGroupCollector();
        collector.setChecker(ctrlInfoChecker);
        collector.init(modelMatchCfg);
        return collector;
    }

    private DataGroupCollector() {
    }

    public void init(ModelMatchCfg modelMatchCfg) {
        Map<String, List<MatchFieldInfo>> matchFieldInfos = modelMatchCfg.getMatchFieldInfos();
        for (Map.Entry<String, List<MatchFieldInfo>> infos : matchFieldInfos.entrySet()) {
            String entity = infos.getKey();
            for (MatchFieldInfo info : infos.getValue()) {
                if (!info.isGroupMatch()) continue;
                CommonUtils.mapGetSetValue(this.groupFields, entity).add(info.getMatchDimSrcKey());
                this.addModelField(info.getModelKey());
            }
        }
    }

    @Override
    public void collect(Collection<SettleBillModel> models, Collection<DynamicObject> dynaObjs) {
        if (CommonUtils.collectionIsEmpty(models) || CommonUtils.collectionIsEmpty(dynaObjs)) {
            return;
        }
        this.collectData(models);
        this.collectGroup(dynaObjs);
    }

    protected void collectGroup(Collection<DynamicObject> dynaObjs) {
        String entityType = dynaObjs.iterator().next().getDataEntityType().getName();
        Set<String> collectFields = this.groupFields.get(entityType);
        if (CommonUtils.collectionIsEmpty(collectFields)) {
            return;
        }
        String[] fields = collectFields.toArray(new String[collectFields.size()]);
        for (DynamicObject dynaObject : dynaObjs) {
            Map<String, List<DynamicObject>> objs = DynamicObjectUtil.getMultiFieldDynamicObjects(dynaObject, fields);
            for (List<DynamicObject> groupObj : objs.values()) {
                if (CommonUtils.collectionIsEmpty(groupObj)) continue;
                String name = groupObj.get(0).getDataEntityType().getName();
                CommonUtils.mapGetSetValue(this.getGroupIdsMap(), name).addAll(DynamicObjectUtil.getDynamicObjectIds(groupObj));
            }
        }
    }
}

