/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.mapcfg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.mapcfg.fieldinfo.MatchFieldInfo;

public class ModelMatchCfg {
    private Map<String, List<MatchFieldInfo>> matchFieldInfos = new HashMap<String, List<MatchFieldInfo>>(16);
    private Set<Long> groupRelationIds = new HashSet<Long>(16);

    public static ModelMatchCfg build() {
        ModelMatchCfg modelMatchCfg = new ModelMatchCfg();
        modelMatchCfg.init();
        return modelMatchCfg;
    }

    private ModelMatchCfg() {
    }

    private void init() {
        Map objs = BusinessDataServiceHelper.loadFromCache((String)"ism_priceruleplan", (String)"srcbillobj, entryentity.sourcefieldkey,entryentity.definetype,entryentity.grouprelation,entryentity.targetfieldkey", (QFilter[])new QFilter("targetbill", "=", (Object)"ism_billmapcfg").toArray());
        for (DynamicObject obj : objs.values()) {
            String sourceBillEntity = obj.getDynamicObject("srcbillobj").getString("number");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)sourceBillEntity);
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
            ArrayList<MatchFieldInfo> billmap = new ArrayList<MatchFieldInfo>(entries.size());
            for (DynamicObject entry : entries) {
                MatchFieldInfo fieldInfo = MatchFieldInfo.build(entry);
                if (entityType.findProperty(fieldInfo.getMatchDimKey()) == null) continue;
                billmap.add(fieldInfo);
                DynamicObject groupRelation = entry.getDynamicObject("grouprelation");
                this.groupRelationIds.add(DynamicObjectUtil.getPkValue(groupRelation));
            }
            this.matchFieldInfos.put(sourceBillEntity, billmap);
        }
    }

    public List<MatchFieldInfo> getMatchMaps(String entity) {
        return this.matchFieldInfos.get(entity);
    }

    public Map<String, List<MatchFieldInfo>> getMatchFieldInfos() {
        return this.matchFieldInfos;
    }

    public Set<Long> getGroupRelationIds() {
        return this.groupRelationIds;
    }
}

