/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.mapcfg.fieldinfo;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;

public class BillFieldInfo {
    private String srcBillFieldKey;
    private String billFieldKey;
    private int keyloc;
    private IDataEntityProperty property;

    public void setProp(IDataEntityProperty property) {
        this.property = property;
    }

    public IDataEntityProperty getProperty() {
        return this.property;
    }

    public BillFieldInfo(String srcBillFieldKey, String billFieldKey, int keyloc) {
        this.srcBillFieldKey = srcBillFieldKey;
        this.billFieldKey = billFieldKey;
        this.keyloc = keyloc;
    }

    public static BillFieldInfo build(String srcBillFieldKey) {
        if (StringUtils.isEmpty((CharSequence)srcBillFieldKey)) {
            return null;
        }
        String[] splitKey = srcBillFieldKey.split("\\.");
        if (splitKey.length <= 0) {
            return null;
        }
        BillFieldInfo info = new BillFieldInfo(srcBillFieldKey, splitKey[splitKey.length - 1], splitKey.length);
        return info;
    }

    public Object getValue(DynamicObject bill, DynamicObject entry) {
        if (this.getKeyloc() == 1) {
            return bill.get(this.getBillFieldKey());
        }
        if (this.getKeyloc() == 2) {
            return entry.get(this.getBillFieldKey());
        }
        return null;
    }

    public String getSrcBillFieldKey() {
        return this.srcBillFieldKey;
    }

    public String getBillFieldKey() {
        return this.billFieldKey;
    }

    public int getKeyloc() {
        return this.keyloc;
    }

    public boolean isBillHead() {
        return 1 == this.getKeyloc();
    }

    public boolean isBillEntry() {
        return 2 == this.getKeyloc();
    }
}

