/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.match.engine.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.match.engine.AbstractMatchEngine;
import kd.scmc.ism.model.match.groupstrategy.IMatchGroupStrategy;
import kd.scmc.ism.model.match.groupstrategy.impl.BillTypePropGroupStrategy;
import kd.scmc.ism.model.match.unit.impl.BizDirectMatchUnit;

public class BizDirectMatchEngine
extends AbstractMatchEngine<BizDirectMatchUnit> {
    public static BizDirectMatchEngine build(String ... billTypes) {
        BizDirectMatchEngine engine = new BizDirectMatchEngine(new BillTypePropGroupStrategy());
        engine.loadObjs(BizDirectMatchEngine.getObjects(billTypes));
        return engine;
    }

    private static Collection<DynamicObject> getObjects(String[] billTypes) {
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        if (CommonUtils.arrayIsNotEmpty(billTypes)) {
            filter.and("bill", "in", (Object)billTypes);
        }
        Map settleJudgements = BusinessDataServiceHelper.loadFromCache((String)"ism_bizdirectjudge", (String)"id, bill, direct, billfilterstr_tag", (QFilter[])filter.toArray());
        return settleJudgements.values();
    }

    protected BizDirectMatchEngine(IMatchGroupStrategy groupStrategy) {
        super(groupStrategy);
    }

    @Override
    protected BizDirectMatchUnit buildUnit(DynamicObject obj) {
        return BizDirectMatchUnit.build(obj);
    }

    public Map<String, Set<String>> getAllFilterField() {
        HashMap<String, Set<String>> fieldsMap = new HashMap<String, Set<String>>(16);
        Map units = this.getUnits();
        for (Map.Entry entry : units.entrySet()) {
            HashSet<String> fields = new HashSet<String>(32);
            for (BizDirectMatchUnit unit : entry.getValue()) {
                fields.addAll(unit.getDimKeys());
            }
            fields.remove(null);
            fields.remove("");
            fieldsMap.put(entry.getKey(), fields);
        }
        return fieldsMap;
    }
}

