/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.match.engine.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.business.helper.CtrlInfoChecker;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.group.DataGroupClassfier;
import kd.scmc.ism.model.mapcfg.ModelMatchCfg;
import kd.scmc.ism.model.mapcfg.fieldinfo.MatchFieldInfo;
import kd.scmc.ism.model.match.engine.impl.AbstractCtrlMatchEngine;
import kd.scmc.ism.model.match.groupstrategy.IMatchGroupStrategy;
import kd.scmc.ism.model.match.groupstrategy.impl.EntryMainIdGroupStrategy;
import kd.scmc.ism.model.match.unit.compare.CombineCompartor;
import kd.scmc.ism.model.match.unit.compare.EffectiveDayCompartor;
import kd.scmc.ism.model.match.unit.compare.PriorityPropCompartor;
import kd.scmc.ism.model.match.unit.impl.PriceRuleEntryMatchUnit;

public class PriceRuleEntryMatchEngine
extends AbstractCtrlMatchEngine<PriceRuleEntryMatchUnit> {
    private ModelMatchCfg matchCfg = null;
    private DataGroupClassfier classfier = null;
    private List<MatchFieldInfo> directMatchFields = new ArrayList<MatchFieldInfo>(16);
    private List<MatchFieldInfo> groupMatchFields = new ArrayList<MatchFieldInfo>(16);

    public static PriceRuleEntryMatchEngine build(ISMServiceContext serviceContext) {
        return PriceRuleEntryMatchEngine.build(serviceContext.getMatchCfg(), serviceContext.getCtrlInfos(), serviceContext.getClassfier());
    }

    public static PriceRuleEntryMatchEngine build(ModelMatchCfg matchCfg, CtrlInfoChecker ctrlInfoChecker, DataGroupClassfier classfier) {
        PriceRuleEntryMatchEngine engine = new PriceRuleEntryMatchEngine(new EntryMainIdGroupStrategy());
        CombineCompartor combineCompartor = new CombineCompartor();
        combineCompartor.addComparator(new PriorityPropCompartor());
        combineCompartor.addComparator(new EffectiveDayCompartor("entrystarteffectivedate"));
        engine.setUnitsComparator(combineCompartor);
        engine.setMatchCfg(matchCfg);
        engine.setCtrlChecker(ctrlInfoChecker);
        engine.setClassfier(classfier);
        engine.parseDimCfgInfo();
        return engine;
    }

    private void parseDimCfgInfo() {
        List<MatchFieldInfo> fieldInfos = this.matchCfg.getMatchMaps("ism_interorgsettlerule");
        if (CommonUtils.collectionIsEmpty(fieldInfos)) {
            return;
        }
        for (MatchFieldInfo fieldInfo : fieldInfos) {
            if (fieldInfo.isGroupMatch()) {
                this.groupMatchFields.add(fieldInfo);
                continue;
            }
            this.directMatchFields.add(fieldInfo);
        }
    }

    protected PriceRuleEntryMatchEngine(IMatchGroupStrategy groupStrategy) {
        super(groupStrategy);
    }

    @Override
    protected PriceRuleEntryMatchUnit buildUnit(DynamicObject obj) {
        PriceRuleEntryMatchUnit unit = PriceRuleEntryMatchUnit.build(obj);
        unit.setChecker(this.getChecker());
        unit.setClassfier(this.classfier);
        unit.initDirectDim(this.directMatchFields);
        unit.initGroupDim(this.groupMatchFields);
        return unit;
    }

    private void setMatchCfg(ModelMatchCfg matchCfg) {
        this.matchCfg = matchCfg;
    }

    public void setClassfier(DataGroupClassfier classfier) {
        this.classfier = classfier;
    }
}

