/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.match.engine.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.model.match.engine.AbstractMatchEngine;
import kd.scmc.ism.model.match.entity.MatchArgs;
import kd.scmc.ism.model.match.entity.MatchResult;
import kd.scmc.ism.model.match.groupstrategy.IMatchGroupStrategy;
import kd.scmc.ism.model.match.groupstrategy.impl.SupAndDemKeyGroupStrategy;
import kd.scmc.ism.model.match.unit.compare.CombineCompartor;
import kd.scmc.ism.model.match.unit.compare.EffectiveDayCompartor;
import kd.scmc.ism.model.match.unit.compare.NumberCompartor;
import kd.scmc.ism.model.match.unit.impl.PriceRuleMatchUnit;

public class PriceRuleMatchEngine
extends AbstractMatchEngine<PriceRuleMatchUnit> {
    public static PriceRuleMatchEngine build() {
        PriceRuleMatchEngine engine = new PriceRuleMatchEngine(new SupAndDemKeyGroupStrategy());
        CombineCompartor compartors = new CombineCompartor();
        compartors.addComparator(EffectiveDayCompartor.getInstance());
        compartors.addComparator(new NumberCompartor());
        engine.setUnitsComparator(compartors);
        return engine;
    }

    protected PriceRuleMatchEngine(IMatchGroupStrategy groupStrategy) {
        super(groupStrategy);
    }

    @Override
    protected PriceRuleMatchUnit buildUnit(DynamicObject obj) {
        return new PriceRuleMatchUnit(obj);
    }

    @Override
    public MatchResult<PriceRuleMatchUnit> doMatch(MatchArgs args) {
        Object suplierId = args.getAdditonInfo().get("supplier");
        Object demandId = args.getAdditonInfo().get("demand");
        MatchResult<PriceRuleMatchUnit> supDemMatch = super.doMatch(args);
        if (supDemMatch.isMatch()) {
            return supDemMatch;
        }
        args.putAddtionInfo("supplier", suplierId);
        args.putAddtionInfo("demand", 0L);
        MatchResult<PriceRuleMatchUnit> onlySupMatch = super.doMatch(args);
        if (onlySupMatch.isMatch()) {
            onlySupMatch.getArgs().putAddtionInfo("demand", demandId);
            return onlySupMatch;
        }
        args.putAddtionInfo("supplier", 0L);
        args.putAddtionInfo("demand", demandId);
        MatchResult<PriceRuleMatchUnit> onlydemMatch = super.doMatch(args);
        onlydemMatch.getArgs().putAddtionInfo("supplier", suplierId);
        return onlydemMatch;
    }
}

