/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.match.loader.impl;

import java.util.ArrayList;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.ism.model.match.loader.AbstractBaseDataLoader;

public class EntryDataLoader
extends AbstractBaseDataLoader {
    private final String billentryKey;

    public static EntryDataLoader build(Collection<DynamicObject> objs, String billentryKey) {
        EntryDataLoader loader = new EntryDataLoader(billentryKey);
        loader.parse(objs);
        return loader;
    }

    public static EntryDataLoader build(Collection<DynamicObject> objs) {
        EntryDataLoader loader = new EntryDataLoader("entryentity");
        loader.parse(objs);
        return loader;
    }

    private EntryDataLoader(String billentryKey) {
        this.billentryKey = billentryKey;
    }

    private void parse(Collection<DynamicObject> objs) {
        ArrayList<DynamicObject> objArrays = new ArrayList<DynamicObject>(128);
        for (DynamicObject obj : objs) {
            DynamicObjectCollection entries = obj.getDynamicObjectCollection(this.billentryKey);
            for (DynamicObject entry : entries) {
                objArrays.add(entry);
            }
        }
        this.setObjs(objArrays);
    }
}

