/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.match.unit.impl;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.scmc.ism.business.func.ConditionFunctionManager;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.args.GenerateBillArgs;
import kd.scmc.ism.common.model.args.GenerateResult;
import kd.scmc.ism.common.model.billgenerator.BillGenerator;
import kd.scmc.ism.common.model.billgenerator.GeneratorFactory;
import kd.scmc.ism.common.model.handler.BillFieldResetRuleHandler;
import kd.scmc.ism.common.model.mapper.DynamicObjectCacheMapper;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.IsmStringUtils;
import kd.scmc.ism.model.bill.ISettleBillModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.match.entity.MatchArgs;
import kd.scmc.ism.model.match.unit.impl.AbstractExpressionUnit;

public class GeneratePlanMatchUnit
extends AbstractExpressionUnit {
    public static final Log log = LogFactory.getLog(GeneratePlanMatchUnit.class);
    private String sourceEntityType = null;
    private ConditionFunctionManager funcManager;
    private BillGenerator generator;
    private BillFieldResetRuleHandler brhandler;

    protected GeneratePlanMatchUnit(DynamicObject resultObject) {
        super(resultObject);
    }

    public static GeneratePlanMatchUnit build(DynamicObject resultObject) {
        GeneratePlanMatchUnit unit = new GeneratePlanMatchUnit(resultObject);
        DynamicObject sourceEntityObj = resultObject.getDynamicObject("sourcebilltype");
        unit.sourceEntityType = sourceEntityObj.getString("number");
        unit.initCondition();
        return unit;
    }

    private void initCondition() {
        String conditionStrs = this.getResultObject().getString("condtionstr_tag");
        if (StringUtils.isEmpty((CharSequence)conditionStrs)) {
            return;
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionStrs, CRCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)this.sourceEntityType), condition.getFilterCondition());
        String[] script = fb.buildFilterScript();
        BOSExpression expression = new BOSExpression(script[0]);
        this.setExpr(expression);
    }

    @Override
    public boolean isMatch(MatchArgs args) {
        return this.checkSrcBill(args) && super.isMatch(args) && this.doFunctionExeucte(args);
    }

    private boolean checkSrcBill(MatchArgs args) {
        ISettleBillModel billModel = args.getBillModel();
        if (billModel == null) {
            return false;
        }
        return billModel.getBillEntityType().equals(this.sourceEntityType);
    }

    private boolean doFunctionExeucte(MatchArgs args) {
        String function = this.getResultObject().getString("function");
        if (StringUtils.isEmpty((CharSequence)function)) {
            return true;
        }
        return this.funcManager.doExeucte(args, function);
    }

    public String getTargetBillType() {
        DynamicObject targetType = this.getResultObject().getDynamicObject("targetbilltype");
        return targetType.getString("number");
    }

    public GenerateResult doGenerate(GenerateBillArgs genArgs, ISMServiceContext serviceContext) {
        BillFieldResetRuleHandler rstHandler;
        String billNumber;
        BillGenerator generator = this.getGenerator(serviceContext);
        GenerateResult result = null;
        try {
            result = generator.generateBill(serviceContext, genArgs);
        }
        catch (Exception e) {
            result = GenerateResult.createFailResult(IsmStringUtils.append(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\uff1a", (String)"GenerateFail", (String)"scmc-ism-form", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        result.setBillType(this.getTargetBillType());
        SettleBillModel billModel = result.getBill();
        if (!result.isSuccess()) {
            return result;
        }
        result.setBizFlow(this.getResultObject().getDynamicObject("bizflow"));
        DynamicObject bill = billModel.getObj();
        DynamicObjectUtil.setBillId(bill, billModel.getEntryKeyField());
        String billno = bill.getString("billno");
        if (StringUtils.isEmpty((CharSequence)billno)) {
            bill.set("billno", (Object)("*" + DynamicObjectUtil.getCodeNumber(bill)));
        }
        if ("im_purinbill".equals(billNumber = genArgs.getSourceBillType()) || "im_ospurinbill".equals(billNumber)) {
            try {
                boolean validate = this.baseQtyValidate(genArgs.getModel().getObj(), bill);
                if (!validate) {
                    String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u751f\u6210\u865a\u5355\u5931\u8d25\uff0c\u6e90\u5355\u548c\u865a\u5355\u7684\u57fa\u672c\u6570\u91cf\u4e0d\u4e00\u81f4\u3002", (String)"GeneratePlanMatchUnit_0", (String)"scmc-ism-form", (Object[])new Object[0]);
                    result.setFailReason(msg);
                    return result;
                }
            }
            catch (Exception e) {
                result.setFailReason(IsmStringUtils.append(ResManager.loadKDString((String)"\u5b9e\u5355\u548c\u865a\u5355\u57fa\u672c\u6570\u91cf\u6821\u9a8c\u5931\u8d25\u3002", (String)"GeneratePlanMatchUnit_1", (String)"scmc-ism-form", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                return result;
            }
        }
        if ((rstHandler = this.getRstHandler(serviceContext)) != null) {
            try {
                rstHandler.resetBillField(bill);
            }
            catch (Exception e) {
                result.setFailReason(IsmStringUtils.append(ResManager.loadKDString((String)"\u91cd\u7f6e\u5931\u8d25\uff1a", (String)"ResetRuleFail", (String)"scmc-ism-form", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                return result;
            }
        }
        return result;
    }

    private boolean baseQtyValidate(DynamicObject srcBill, DynamicObject generateBill) {
        DynamicObjectCollection srcBillEntryCol = srcBill.getDynamicObjectCollection("billentry");
        DynamicObjectCollection generateBillEntryCol = generateBill.getDynamicObjectCollection("billentry");
        for (int i = 0; i < srcBillEntryCol.size(); ++i) {
            DynamicObject srcBillEntry = (DynamicObject)srcBillEntryCol.get(i);
            Object srcPkValue = srcBillEntry.getPkValue();
            BigDecimal srcBaseQty = srcBillEntry.getBigDecimal("baseqty").abs();
            BigDecimal genBaseQty = null;
            for (DynamicObject genBillEntry : generateBillEntryCol) {
                Object srcBillEntryId = genBillEntry.get("srcbillentryid");
                if (!srcPkValue.equals(srcBillEntryId)) continue;
                genBaseQty = genBillEntry.getBigDecimal("baseqty").abs();
                break;
            }
            if (genBaseQty != null && srcBaseQty.compareTo(genBaseQty) == 0) continue;
            return false;
        }
        return true;
    }

    public BillGenerator getGenerator(ISMServiceContext serviceContext) {
        if (this.generator == null) {
            this.generator = GeneratorFactory.build(serviceContext, this.getResultObject());
        }
        return this.generator;
    }

    public BillFieldResetRuleHandler getRstHandler(ISMServiceContext serviceContext) {
        if (this.brhandler == null) {
            this.initRstHandler(serviceContext);
        }
        return this.brhandler;
    }

    private void initRstHandler(ISMServiceContext serviceContext) {
        DynamicObject resetRule = this.getResultObject().getDynamicObject("billfieldresetrule");
        if (resetRule != null) {
            DynamicObjectCacheMapper doservice = serviceContext.getService(DynamicObjectCacheMapper.class);
            long resetRuleId = resetRule.getLong("id");
            resetRule = doservice.get("ism_billfieldresetrule", resetRuleId);
            this.brhandler = BillFieldResetRuleHandler.build(resetRule);
        }
    }

    public void setFuncManager(ConditionFunctionManager funcManager) {
        this.funcManager = funcManager;
    }

    public String getSourceEntityType() {
        return this.sourceEntityType;
    }
}

