/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.match.unit.impl;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.orm.query.QFilter;
import kd.scmc.ism.business.helper.MatchConditionHelper;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.ISettleBillModel;
import kd.scmc.ism.model.group.expr.GroupMatchEntryExpression;
import kd.scmc.ism.model.mapcfg.fieldinfo.MatchFieldInfo;
import kd.scmc.ism.model.match.entity.MatchArgs;
import kd.scmc.ism.model.match.unit.impl.AbstractGroupExpressionUnit;

public class PriceRuleEntryMatchUnit
extends AbstractGroupExpressionUnit {
    public static PriceRuleEntryMatchUnit build(DynamicObject resultObject) {
        PriceRuleEntryMatchUnit unit = new PriceRuleEntryMatchUnit(resultObject);
        return unit;
    }

    private PriceRuleEntryMatchUnit(DynamicObject resultObject) {
        super(resultObject);
    }

    @Override
    public boolean isMatch(MatchArgs args) {
        return this.isEffective(args.getBillModel()) && super.isMatch(args);
    }

    private boolean isEffective(ISettleBillModel model) {
        Date startDate = this.getResultObject().getDate("entrystarteffectivedate");
        Date endDate = this.getResultObject().getDate("entryendeffectivedate");
        Date bizTime = null;
        if (model != null) {
            bizTime = (Date)model.getValue("biztime");
        }
        return MatchConditionHelper.isOnEffective(bizTime, startDate, endDate);
    }

    public void initDirectDim(List<MatchFieldInfo> directMatchFields) {
        DynamicObject priceRuleEntry = this.getResultObject();
        StringBuilder exprBuilder = new StringBuilder();
        boolean addAnd = false;
        for (MatchFieldInfo info : directMatchFields) {
            String dimKey = info.getMatchDimKey();
            String modelKey = info.getModelKey();
            Object value = priceRuleEntry.get(dimKey);
            if (value == null) continue;
            if (value instanceof DynamicObject) {
                value = this.getMasterObjectId((DynamicObject)value);
            } else if (value instanceof String && StringUtils.isEmpty((CharSequence)((String)value))) continue;
            if (addAnd) {
                exprBuilder.append(" AND ");
            } else {
                addAnd = true;
            }
            exprBuilder.append(new QFilter(modelKey, "=", value));
        }
        String expression = exprBuilder.toString();
        if (StringUtils.isNotEmpty((CharSequence)expression)) {
            this.setExpr(new BOSExpression(expression));
        }
    }

    public void initGroupDim(List<MatchFieldInfo> groupMatchFields) {
        GroupMatchEntryExpression conditions = new GroupMatchEntryExpression();
        for (MatchFieldInfo fieldInfo : groupMatchFields) {
            String dimKey = fieldInfo.getMatchDimKey();
            DynamicObject groupObj = this.getResultObject().getDynamicObject(dimKey);
            if (groupObj == null) continue;
            conditions.addFactor(fieldInfo.getModelKey(), DynamicObjectUtil.getPkValue(groupObj), DynamicObjectUtil.getPkValue(fieldInfo.getGroupRelation()));
        }
        this.setGroupCondition(conditions);
    }
}

